@ The productions.
% $Id: rules.w,v 1.2 1991/08/06 16:09:15 fj Exp $

The purpose of the first group of rules is to absorb insertions (\Cee\
comments and preprocessor lines) before we try to apply any other
rule.  This implies that any category will in general represent
something appropriate for the category followed by any number
(including zero) of ``insertions.''

@<Global...@>=
production rule0 = { 0, { begin_arg, end_arg }, { expression, "%0%1" } };

production rule1 = { 1, { any, end_arg }, { end_arg, "%0%1" } };

production rule2 = { 2, { any, insert }, { any, "%0%1" } };

production rule3 = { 3, { any, any, insert }, { any + 1, "%1%2" }, 1 };

production rule4 = { 4, { any, any, any, insert }, { any + 2, "%2%3" }, 2 };

@
@<Set initial...@>=
 {  install_production (&rule0);
    install_production (&rule1);
    install_production (&rule2);
    install_production (&rule3);
    install_production (&rule4);
 }



@ {\it Expressions}.

These rules should be obvious.

@<Global...@>=
production rule13 = { 13, { expression, unop }, { expression, "%0%1" } };

production rule14 = { 14, { expression, binop, expression },
			  { expression, "%0%1%2" } };

production rule15 = { 15, { expression, unorbinop, expression },
			  { expression, "%0%1%2" } };

production rule16 = { 16, { expression, comma, expression },
			  { expression, "%0%1%p9%2" } };

production rule17 = { 17, { expression, expression }, { expression, "%0%1" } };

production rule18 = { 18, { expression, subscript }, { expression, "%0%1" } };

@
@<Set initial...@>=
 {  install_production (&rule13);
    install_production (&rule14);
    install_production (&rule15);
    install_production (&rule16);
    install_production (&rule17);
    install_production (&rule18);
 }



@ |rule22|: A cast is syntactically a subset of parameter lists for
new-style function declarators.

@<Global...@>=
production rule20 = { 20, { lpar, expression, rpar },
			  { expression, "%0%1%2" } };

production rule21 = { 21, { lpar, rpar }, { parameters, "%0%,%1" } };

production rule22 = { 22, { parameters }, { cast, "%0" } };

production rule23 = { 23, { lbrack, expression, rbrack },
			  { subscript, "%0%1%2" } };

production rule24 = { 24, { lbrack, rbrack }, { subscript, "%0%,%1" } };


@
@<Set initial...@>=
 {  install_production (&rule20);
    install_production (&rule21);
/*|
    install_production (&rule22);
|*/
    install_production (&rule23);
    install_production (&rule24);
 }



@ Conditional operator.

@<Global...@>=
production rule30 = { 30, { question, expression, colon },
			  { binop, "%0%1%2" } };

@
@<Set initial...@>=
install_production (&rule30);



@ These rules are not quite perfect: The braces around the unary
operator in |rule50| (with the purpose of making it behave as a
`mathord' atom) can cause \TeX\ to fail; this happens when there is a
comment after the operator.

@<Global...@>=
production rule40 = { 40, { unop, expression }, { expression, "%0%1" } };

production rule50 = { 50, { unorbinop, expression },
			  { expression, "{%0}%1" } };

@
@<Set initial...@>=
 {  install_production (&rule40);
    install_production (&rule50);
 }



@ |rule70| takes care of casts.

@<Global...@>=
production rule70 = { 70, { parameters, expression },
                          { expression, "%0%,%1" } };

production rule72 = { 72, { sizeof_like, parameters },
                          { expression, "%0%1" } };

production rule73 = { 73, { sizeof_like, expression },
			  { expression, "%0%,%1" } };

@
@<Set initial...@>=
 {  install_production (&rule70);
    install_production (&rule72);
    install_production (&rule73);
 }



@ {\it Declarations}.

These rules parse declarations as an |int_like| followed by an |expression|.

Warning: This is tricky!

|rule80| accumulates declaration specifiers, and it also joins
parameters in new-style function declarators.

|rule81| parses an ``empty'' declaration.

|rule82| parses the last declarator in a declaration.

|rule83| parses the next declarator in a declaration.

|rule84| deals with constant and volatile pointers.

|rule85| absorbs the parameter list for a new-style function declarator.

|rule86| parses a parameter list ending with an ellipsis or an
abstract declarator.

|rule87| parses a parameter list ending with a ``concrete''
declarator.

|rule88| parses a parameter without a declarator.

|rule90| and |rule91| parse the first part of bit-fields within
structures.

The last 9 rules (140, \dots) deal with abstract declarators (I hope I
got it right! There {\it has\/} to be a simpler way!).

With respect to abstract declarators: if they are not fully abstract,
some identifiers may get underlined in the index when they should only
get a normal (non-underlined) entry.

@<Global...@>=
production rule80 = { 80, { int_like, int_like }, { int_like, "%0~%1" } };

production rule81 = { 81, { int_like, semi }, { declaration, "%0%1" } };

production rule82 = { 82, { int_like, expression, semi },
			  { declaration, "%0~%!1%2" } };

production rule83 = { 83, { int_like, expression, comma },
			  { int_like, "%0~%!1%2%p5" } };

production rule84 = { 84, { unorbinop, int_like },
			  { unorbinop, "{%0}%1~" } };

production rule85 = { 85, { expression, parameters },
			  { expression, "%0%+%+%+%t%1%-%-%-" } };

production rule92 = { 92, { expression, lpar, rpar },
			  { expression, "%0%1%,%2" } };

production rule86 = { 86, { lpar, int_like, rpar }, { parameters, "%0%1%2" } };

production rule87 = { 87, { lpar, int_like, expression, rpar },
			  { parameters, "%0%1~%!2%3" } };

production rule88 = { 88, { int_like, comma }, { int_like, "%0%1%p5" } };

production rule90 = { 90, { int_like, expression, colon },
			  { int_like, "%0~%1~%2" } };

production rule91 = { 91, { int_like, colon }, { int_like, "%0~%1" } };

production rule140 = { 140, { unorbinop, dad },
			   { dad, "%0%1" } };

production rule141 = { 141, { unorbinop, rpar },
			   { dad, "%0" }, -1 };

production rule141b = { 141, { unorbinop, comma },
			   { dad, "%0" }, -1 };

production rule142 = { 142, { lpar, dad, rpar },
			   { dad, "%0%1%2" } };

production rule143 = { 143, { parameters, dad },
			   { dad, "%0%1" } };

production rule144 = { 144, { subscript, dad },
			   { dad, "%0%1" } };

production rule145 = { 145, { int_like, dad, comma },
			   { int_like, "%0%,%1%2%p5" } };

production rule146 = { 146, { lpar, int_like, dad, rpar },
			  { parameters, "%0%1%,%2%3" } };

production rule147 = { 147, { parameters, comma }, { dad, "%0" }, -1 };

production rule148 = { 148, { parameters, rpar }, { dad, "%0" }, -1 };

production rule149 = { 149, { subscript, comma }, { dad, "%0" }, -1 };

production rule150 = { 150, { subscript, rpar }, { dad, "%0" }, -1 };

@
@<Set initial...@>=
 {  install_production (&rule80);
    install_production (&rule81);
    install_production (&rule82);
    install_production (&rule83);
    install_production (&rule84);
    install_production (&rule85);
    install_production (&rule86);
    install_production (&rule87);
    install_production (&rule88);
    install_production (&rule90);
    install_production (&rule91);
    install_production (&rule92);
    install_production (&rule140);
    install_production (&rule141);
    install_production (&rule141b);
    install_production (&rule142);
    install_production (&rule143);
    install_production (&rule145);
    install_production (&rule146);
    install_production (&rule147);
    install_production (&rule148);
    install_production (&rule149);
    install_production (&rule150);
 }



@ Structure, union, and enumeration declarations.

|rule122| and |rule124| allow typedef names to be used as tags.

@<Global...@>=
production rule120 = { 120, { struct_like, lbrace },
			   { struct_head, "%0~%1" } };

production rule121 = { 121, { struct_like, expression, lbrace },
                         { struct_head, "%0~%!1~%2" } };

production rule125 = { 125, { struct_like, expression, lbrace },
                         { struct_head, "%0~%!*1~%2" } };

production rule122 = { 122, { struct_like, int_like, lbrace },
                         { struct_head, "%0~%!$1~%2" } };

production rule126 = { 126, { struct_like, int_like, lbrace },
                         { struct_head, "%0~%!1~%2" } };

production rule123 = { 123, { struct_like, expression },
                         { int_like, "%0~%1" } };

production rule124 = { 124, { struct_like, int_like },
                         { int_like, "%0~%$1" } };

production rule127 = { 127, { struct_like, expression },
                         { int_like, "%0~%*1" } };

production rule128 = { 128, { struct_like, int_like },
                         { int_like, "%0~%1" } };

@
@<Set initial...@>=
 {  install_production (&rule120);
    if (!C_plus_plus) {
	install_production (&rule121);
	install_production (&rule122);
	install_production (&rule123);
	install_production (&rule124);
    } else {
	install_production (&rule125);
	install_production (&rule126);
	install_production (&rule127);
	install_production (&rule128);
    }
 }



@ The last two rules are for enumerations; there are two cases:
(a)~two or more identifiers are being declared, (b)~one identifier is
declared.  The first rule absorbs the second identifier into the first
(and underlines it in the index), and the second rule absorbs the
first identifier (this rule is applied as the last step).

@<Global...@>=
production rule130 = { 130, { struct_head, declaration, rbrace },
                         { int_like, "%0%+%f%1%-%f%2" } };

production rule132 = { 132, { struct_head, expression, comma, expression },
                         { expression, "%1%2%B%!3" }, 1 };

production rule133 = { 133, { struct_head, expression, rbrace },
                         { int_like, "%0%+%,%!1%-%,%2" } };

@
@<Set initial...@>=
 {  install_production (&rule130);
    install_production (&rule132);
    install_production (&rule133);
 }



@ Typedef declarations.  Here we make the declared identifiers
reserved (behave like |int|).

@<Global...@>=
production rule110 = { 110, { typedef_like, int_like, expression, semi },
			   { declaration, "%0~%1~%!*2%3" } };

production rule111 = { 111, { typedef_like, int_like, expression, comma },
			   { int_like, "%1~%!*2%3%p5" }, 1 };

production rule112 = { 112, { typedef_like, declaration },
                         { declaration, "%0~%1" } };

@
@<Set initial...@>=
 {  install_production (&rule110);
    install_production (&rule111);
    install_production (&rule112);
 }



@ {\it Statements}.  Here we have two alternative rules for combining
statements.  We use the first, if |force_main_statements| is chosen
(the default); otherwise, we use the second rule.

@d force_main_statements flags['f']
	/* should each statement (within a block) be on its own line? */
@d force_all_statements flags['a']

@<Global...@>=
production rule200 = { 200, { statement, statement },
			   { statement, "%0%f%1" } };
production rule201 = { 201, { statement, statement },
			   { statement, "%0%B%1" } };

@
@<Set initial...@>=
if (force_main_statements || force_all_statements)
    install_production (&rule200);
else install_production (&rule201);



@ Labeled statements.

|rule190| takes care of identifier labels; the identifier is declared.

|rule191| and |rule192| take care of case labels and default labels.

@<Global...@>=
production rule190 = { 190, { expression, colon }, { label, "%!0%h%1" } };

production rule191 = { 191, { case_like, expression, colon },
                         { label, "%0 %1%h%2" } };

production rule192 = { 192, { case_like, colon },
                         { label, "%0%h%1" } };

production rule193 = { 193, { label, label },
                         { label, "%0%B%1" } };

production rule194 = { 194, { label, statement },
                         { statement, "%f%b%0%B%1" } };

production rule195 = { 195, { label, statement },
                         { statement, "%f%b%0%f%1" } };

@
@<Set initial...@>=
 {  install_production (&rule190);
    install_production (&rule191);
    install_production (&rule192);
    install_production (&rule193);
    if (force_all_statements)
	install_production (&rule195);
    else install_production (&rule194);
 }



@ Expression statements.

|rule205| takes care of expression statements (such as assignments and
function calls).

|rule206| takes care of null statements.

@<Global...@>=
production rule205 = { 205, { expression, semi }, { statement, "%0%1" } };

production rule206 = { 206, { semi }, { statement, "%0" } };

@
@<Set initial...@>=
{   install_production (&rule205);
    install_production (&rule206);
}



@ Compound statements and aggregate initializers.

@<Global...@>=
production rule156 = { 156, { lbrace, rbrace },
                         { compound_statement, "%0%,%1" } };

production rule151 = { 151, { lbrace, statement, rbrace },
                         { compound_statement, "%0%+%f%1%-%f%2" } };

production rule152 = { 152, { lbrace, declaration, rbrace },
                         { compound_statement, "%0%+%f%1%-%f%2" } };

production rule153 = { 153, { compound_statement }, { statement, "%f%0%f" } };

production rule154 = { 154, { lbrace, expression, comma, rbrace },
                         { expression, "%0%1%2%3" } };

production rule155 = { 155, { lbrace, expression, rbrace },
                         { expression, "%0%1%2" } };

@
@<Set initial...@>=
 {  install_production (&rule156);
    install_production (&rule151);
    install_production (&rule152);
    install_production (&rule153);
    install_production (&rule154);
    install_production (&rule155);
 }



@ Selection and iteration statements.

The following rules take care of formatting |if|-, |if|-|else|-,
|if|-|else if|-, |switch|-, |for|-, and |while|-statements.

We use three categories: |if_like| means we have seen an |if|;
|if_head| means we have seen an |if| followed by an expression;
|if_else_head| means we have seen something like |if(e)s@;else|,
|for(e1;e2;e3)|, |while(e)|, or |switch(e)|---in general something that
will be followed by an indented statement (|else| cannot follow this
category).

In order to achieve standard K+R formatting, we need to check for
|else|-|if| combinations in order to prevent double indentation
(|rule161| and |rule162|).

|rule25| is used to parse the control part of |for|-loops.

@<Global...@>=
production rule160 = { 160, { if_like, expression }, { if_head, "%f%0~%1" } };

production rule161 = { 161, { if_head, compound_statement, else_like,
				  if_like },
			   { if_like, "%0~%1~%2~%3" } };

production rule162 = { 162, { if_head, statement, else_like, if_like },
			   { if_like, "%0%+%B%1%-%f%2~%3" } };

production rule162b = { 162, { if_head, statement, else_like, if_like },
			   { if_like, "%0%+%f%1%-%f%2~%3" } };

production rule163 = { 163, { if_head, compound_statement, else_like },
			   { if_else_head, "%0~%1~%2" } };

production rule164 = { 164, { if_head, statement, else_like },
			   { if_else_head, "%0%+%B%1%-%f%2" } };

production rule164b = { 164, { if_head, statement, else_like },
			   { if_else_head, "%0%+%f%1%-%f%2" } };

production rule165 = { 165, { if_else_head, compound_statement },
			   { statement, "%0~%1%f" } };

production rule166 = { 166, { if_else_head, statement },
			   { statement, "%0%+%B%1%-%f" } };

production rule166b = { 166, { if_else_head, statement },
			   { statement, "%0%+%f%1%-%f" } };

production rule167 = { 167, { if_head, compound_statement },
			   { statement, "%0~%1%f" } };

production rule168 = { 168, { if_head, statement },
			   { statement, "%0%+%B%1%-%f" } };

production rule168b = { 168, { if_head, statement },
			   { statement, "%0%+%f%1%-%f" } };

production rule169 = { 169, { while_like, expression },
			   { if_else_head, "%f%0~%1" } };

production rule25 = { 25, { lpar, statement }, { lpar, "%0%1 " } };

@
@<Set initial...@>=
 {  install_production (&rule160);
    install_production (&rule161);
    install_production (&rule163);
    install_production (&rule165);
    install_production (&rule167);
    install_production (&rule169);
    install_production (&rule25);
    if (force_all_statements) {
	install_production (&rule162b);
	install_production (&rule164b);
	install_production (&rule166b);
	install_production (&rule168b);
    } else {
	install_production (&rule162);
	install_production (&rule164);
	install_production (&rule166);
	install_production (&rule168);
    }
 }



@ Here are the rules for |do|-|while| loops.

@<Global...@>=
production rule170 = { 170, { do_like, compound_statement, while_like },
			   { do_head, "%0~%1~%2" } };

production rule171 = { 171, { do_like, statement, while_like },
			   { do_head, "%0%+%B%1%-%B%2" } };

production rule172 = { 172, { do_like, statement, while_like },
			   { do_head, "%0%+%f%1%-%f%2" } };

production rule173 = { 173, { do_head, expression, semi },
			   { statement, "%f%0~%1%2%f" } };

@
@<Set initial...@>=
 {  install_production (&rule170);
    if (force_all_statements)
	install_production (&rule172);
    else install_production (&rule171);
    install_production (&rule173);
 }



@ Jump statements. (|goto|, |continue|, |break|, and |return|
statements.)

@<Global...@>=
production rule180 = { 180, { return_like, semi },
                         { statement, "%0%1" } };

production rule181 = { 181, { return_like, expression, semi },
                         { statement, "%0 %1%2" } };

@
@<Set initial...@>=
 {  install_production (&rule180);
    install_production (&rule181);
 }



@ {\it External declarations}.  Rules for sequential composition of
function definitions and declarations (within a translation unit) and
composition of declarations and statements (in compound statements).

@<Global...@>=
production rule100 = { 100, { declaration, declaration },
			   { declaration, "%0%f%1" } };

production rule101 = { 101, { declaration, function },
			   { function, "%0%F%1" } };

production rule102 = { 102, { function, declaration },
			   { declaration, "%0%F%1" } };

production rule103 = { 103, { function, function },
			   { function, "%0%F%1" } };

production rule104 = { 104, { declaration, statement },
			   { statement, "%0%F%1" } };

@
@<Set initial...@>=
 {  install_production (&rule100);
    install_production (&rule101);
    install_production (&rule102);
    install_production (&rule103);
    install_production (&rule104);
 }



@ Function definitions.

|rule11| (old-style only) and |rule10| are for function definitions
where the return type defaults to |int|; |rule95| is for function
definitions with specified return type.

@<Global...@>=
production rule11 = { 11, { expression, compound_statement },
			  { function, "%!0%f%1" } };

production rule12 = { 12, { expression, declaration, compound_statement },
			  { function, "%!0%+%+%f%1%-%-%f%2" } };

production rule95 = { 95, { int_like, function },
                         { function, "%0~%1" } };

@
@<Set initial...@>=
 {  install_production (&rule11);
    install_production (&rule12);
    install_production (&rule95);
 }




@
@<Global...@>=
production rule210 = { 210, { lproc, if_like }, { lproc, "%0%1" } };

production rule211 = { 211, { lproc, else_like }, { lproc, "%0%1" } };

production rule212 = { 212, { lproc, define_like }, { lproc, "%0%1" } };

production rule213 = { 213, { lproc, rproc }, { insert, "%0%1" } };

production rule214 = { 214, { lproc, expression, rproc },
			   { insert, "%0 %1%2" } };

production rule215 = { 215, { lproc, expression, expression, rproc },
			   { insert, "%0 %1 \\5%2%3" } };

production rule216 = { 216, { lproc, function, rproc },
			   { insert, "%0 %1%2" } };

production rule217 = { 217, { insert, any }, { any + 1, "%0%1" } };

@
@<Set initial...@>=
 {  install_production (&rule210);
    install_production (&rule211);
    install_production (&rule212);
    install_production (&rule213);
    install_production (&rule214);
    install_production (&rule215);
    install_production (&rule216);
    install_production (&rule217);
 }



@ Rules for interpretation of module names: we adopt the convention
that a module name followed by zero, one, or two semi-colons (`\.;' or
`\.{@@;}') denotes an expression, a statement, or a declaration,
respectively.

@<Global...@>=
production rule220 = { 220, { mod_scrap }, { expression, "%0" } };

production rule221 = { 221, { mod_scrap, semi },
                         { statement, "%0%1%f" } };

production rule222 = { 222, { mod_scrap, semi, semi },
                         { declaration, "%0%1%2" } };

@
@<Set initial...@>=
 {  install_production (&rule220);
    install_production (&rule221);
    install_production (&rule222);
 }
