;;; zenirc-oink.el --- auto-oink

;; Copyright (C) 1995 Noah S. Friedman

;; Author: Noah Friedman <friedman@prep.ai.mit.edu>
;; Maintainer: friedman@prep.ai.mit.edu
;; Keywords: zenirc, extensions
;; Created: 1995-04-09

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:
;;; Code:

(require 'zenirc)

(defvar zenirc-oink-mode t)
(make-variable-buffer-local 'zenirc-oink-mode)

(defvar zenirc-oink-regexp "oink\\|knio")

(defvar zenirc-oink-function 'zenirc-oink-random)

(defvar zenirc-oink-response-percentage 10)

(defvar zenirc-oink-rants
  '("oink"
    "oink!"
    "oink."
    "bozoink"
    "oinkage"
    "knio"
    "you will be in your oink soon"
    "don't say oink"
    ":1 s/oink/oink oink/g; b 1"
    ;; the oink combinator
    "(define oink (lambda (oink?) ((lambda (oink) (oink? (lambda (oink!) ((oink oink) oink!)))) (lambda (oink) (oink? (lambda (oink!) ((oink oink) oink!)))))))"))

;; Changing this to NOTICE will generally avoid loops from other clients
;; that also load this.  But that's less fun.
(defvar zenirc-oink-response-type "PRIVMSG")

(defun zenirc-oink-mode (&optional prefix)
  (interactive "P")
  (setq zenirc-oink-mode (>= (prefix-numeric-value prefix) 0))
  (cond ((not (interactive-p)))
        (zenirc-oink-mode
         (message "zenirc-oink-mode is enabled"))
        (t
         (message "zenirc-oink-mode is disabled")))
  zenirc-oink-mode)

(defun zenirc-oink-random (parsedmsg)
  (nth (abs (% (random) (length zenirc-oink-rants)))
       zenirc-oink-rants))

;; parsedmsg[1]: from
;; parsedmsg[2]: to
;; parsedmsg[3]: text of message
(defun zenirc-oink (proc parsedmsg)
  (and zenirc-oink-mode
       (< (% (abs (random)) 100) zenirc-oink-response-percentage)
       (save-match-data
         (cond
          ((string-match zenirc-oink-regexp (aref parsedmsg 3))
           (let ((to (if (zenirc-names-equal-p (aref parsedmsg 2) zenirc-nick)
                         ;; message was private; reply to sender
                         (zenirc-extract-nick (aref parsedmsg 1))
                       ;; message was public. reply to channel.
                       (aref parsedmsg 2)))
                 (rant (funcall zenirc-oink-function parsedmsg)))
             (zenirc-message proc 'oink-sent to rant)
             (process-send-string proc (format "%s %s :%s\n"
                                               zenirc-oink-response-type
                                               to rant))))))))


(zenirc-add-hook 'zenirc-server-PRIVMSG-hook 'zenirc-oink 'append)

(zenirc-lang-store-catalog-entry
 'oink-sent "[info] Sent to %s: %s\n" 'english)

(provide 'zenirc-oink)

;; zenirc-oink.el ends here
