;;; zenirc-yow.el --- important pinheadery for ZenIRC

;; Copyright (C) 1994, 1995 Noah S. Friedman
;; Copyright (C) 1994, 1995, 1996 Per Persson

;; Author: Noah Friedman <friedman@prep.ai.mit.edu>
;;         Per Persson <pp@gnu.ai.mit.edu>
;; Maintainer: pp@gnu.ai.mit.edu
;; Keywords: zenirc, extensions, oink, yow
;; Created: 1994-06-30

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;; ANN JILLIAN'S HAIR makes LONI ANDERSON'S HAIR look like
;; RICARDO MONTALBAN'S HAIR!

;;; Code:

(require 'zenirc)

;; v18 yow.el didn't have a `provide'
(or (fboundp 'yow) (load "yow"))


(defvar zenirc-yow-regexp "\\byow\\b"
  "*Regexp matching PRIVMSGs which deserve a random zippy quote in response.")

(defvar zenirc-send-yow t
  "*If 't', send yow. If 'nil', don't.")
(make-variable-buffer-local 'zenirc-send-yow)

(defvar zenirc-command-yow-hook '(zenirc-command-yow)
  "*Hook to call when a /yow command is issued in ZenIRC.

The syntax of the command is: /yow victim.
If no victim is specified, the current victim as specified by
zenirc-current-victim is used.")


;; Strip newlines and excess whitespace from string.
(defun zenirc-yow-format-string (s)
  (let ((orig-buffer (current-buffer))
        (temp-buffer (generate-new-buffer " *Yow*")))
    (unwind-protect
        (progn
          (set-buffer temp-buffer)
          ;; don't make undo records in temp buffer
          (let ((buffer-undo-list t))
            (insert s)
            (goto-char (point-min))
            (save-match-data
              (while (re-search-forward "[ \t\n\r]+" nil t)
                (replace-match " ")))
            (setq s (buffer-substring (point-min) (point-max)))))
      (set-buffer orig-buffer)
      (kill-buffer temp-buffer)))
  s)

(defun zenirc-server-PRIVMSG-yow (proc parsedmsg)
  "Respond to pertinent pinheadery with a random zippy quote.
The variable `zenirc-yow-regexp' controls this."
  (if zenirc-send-yow
      (save-match-data
	(let ((case-fold-search t))
	  (cond ((and zenirc-yow-regexp
		      (string-match zenirc-yow-regexp (aref parsedmsg 3)))
		 (let* ((to (aref parsedmsg 2))
			(victim (cond
				 ((zenirc-names-equal-p to zenirc-nick)
				  (zenirc-extract-nick (aref parsedmsg 1)))
				 (t to)))
			(msg (zenirc-yow-format-string (yow))))
		   (zenirc-message proc 'yow-sent victim msg)
		   (process-send-string
		    proc (concat "PRIVMSG " victim " :" msg "\n")))))))))

(defun zenirc-command-yow (proc victim)
  "Send a zippy quote to a specified victim.
See `zenirc-command-yow-hook' for more information."
  (setq victim (cdr victim))
  (cond ((or (null victim)
             (string= "" victim))
         (setq victim zenirc-current-victim)))
  (let ((msg (zenirc-yow-format-string (yow))))
    (zenirc-message proc 'yow-sent victim msg)
    (process-send-string proc (concat "PRIVMSG " victim " :" msg "\n"))))


(provide 'zenirc-yow)

(zenirc-lang-store-catalog-entry 'yow-sent "[info] Sent to %s: %s\n" 'english)

(zenirc-add-hook 'zenirc-server-PRIVMSG-hook
                 'zenirc-server-PRIVMSG-yow 'append)

;;; zenirc-yow.el ends here
