;;;
;;;
;;; zenirc-fancy-format.el --- Format nick!user@host for zenirc.el

;;; Copyright (C) 1993, 1994 Ben A. Mesander

;;; Author: Ben A. Mesander <ben@gnu.ai.mit.edu>
;;;         Charles Hannum <mycroft@gnu.ai.mit.edu>
;;;         Richard Todd <rmtodd@essex.ecn.uoknor.edu>
;;; Maintainer: ben@gnu.ai.mit.edu
;;; Keywords: extensions
;;; Created: 1993/06/03

;;; $Id: zenirc-fancy-format.el,v 1.11 1994/04/27 17:47:31 ben Exp $

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, you can either send email to this
;;; program's maintainer or write to: The Free Software Foundation,
;;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;;; Format nick!user@host info the first time you see someone as
;;; nick!user@host and thereafter as just nick. Nick changes are detected
;;; and handled correctly.
;;;
;;; You might want to preload zenirc-nickuserhost-list with people you usually
;;; see on irc.
;;;
;;; Entries are moved to the front of the alist as they are used.  This should
;;; save a lot of time in (assoc) as groups of messages tend to be from a small
;;; group of people.
;;; 

;;; Code:

(defvar zenirc-nickuserhost-list '()
  "*Association list of ("nick" . "nick!user@host") pairs that you have already seen")

(zenirc-add-hook 'zenirc-format-nickuserhost-hook
		 'zenirc-format-nickuserhost-fancy)
(defun zenirc-format-nickuserhost-fancy (nickuserhost)
  (let ((nick (zenirc-extract-nick nickuserhost)))
    (if nick
	(let ((entry (assoc nick zenirc-nickuserhost-list)))
	  (setq zenirc-run-next-hook nil)
	  (if entry
	      (progn
		(if (not (eq (car zenirc-nickuserhost-list) entry))
		    (setq zenirc-nickuserhost-list
			  (cons entry (delq entry zenirc-nickuserhost-list))))
		(if (string= nickuserhost (cdr entry))
		    (zenirc-extract-nick nickuserhost)
		  (setcdr entry nickuserhost)))
	    (setq zenirc-nickuserhost-list (cons (cons nick nickuserhost) 
						 zenirc-nickuserhost-list))
	    nickuserhost))
      nickuserhost)))

(zenirc-add-hook 'zenirc-server-NICK-hook 'zenirc-fancy-NICK)
(defun zenirc-fancy-NICK (proc parsedmsg)
  (let* ((from (aref parsedmsg 1))
	 (entry (assoc (zenirc-extract-nick from) zenirc-nickuserhost-list)))
    (if entry
	(if (string= (aref parsedmsg 1) (cdr entry))
	    (zenirc-run-hook 'zenirc-format-nickuserhost-hook
	     (concat (aref parsedmsg 2) (substring 
					from (string-match "[!@]" from))))))))
  
;;
;; Also hook into the /who display.  (added by rmtodd@servalan.servalan.com)
;;
(zenirc-add-hook 'zenirc-server-352-hook 'zenirc-fancy-352)
(defun zenirc-fancy-352 (proc parsedmsg)
  (if (not (string= (aref parsedmsg 3) "Channel"))
      ;; It's not the header, snarf the nick, user, host out of it. 
      (let* ((nick (aref parsedmsg 7))
	     (nickuserhost (concat nick "!" (aref parsedmsg 4) "@" 
				   (aref parsedmsg 5)))
	     (entry (assoc nick zenirc-nickuserhost-list)))
	(if entry 
	    ;; is on the list, check if it matches the current userhost.
	    (if (not (string= nickuserhost (cdr entry)))
		;; Nope, so let zenirc-format-nickuserhost-hook add it.
		(zenirc-run-hook 'zenirc-format-nickuserhost-hook
				 nickuserhost))
	  ;; Not on the list, so add it using zenirc-format-nickuserhost-hook
	  (zenirc-run-hook 'zenirc-format-nickuserhost-hook nickuserhost)))))
