/*
 * ctcp.c: client to client protocol
 *
 * Copyright(c) 1997,1998,1999 - All Rights Reserved
 *
 * See the COPYRIGHT file.
 */

#ifndef lint
static char rcsid[] = "@(#)$Id: ctcp.c,v 1.11 1999/01/02 22:14:19 kalt Exp $";
#endif

#include "os.h"

#include "server.h"
#include "utils.h"
#include "patchlevel.h"

extern	int	cmd_msgnotice(char *, char *);

/*
 * user commands
 */

/* cmd_ctcp: send out a CTCP request */
int
cmd_ctcp(p)
  char *p;
{
  char *wp, *wp2, wbuf[512];

  wp = index(p, ' ');
  if (!wp)
      return -1;
  *wp++ = '\0';
  wp2 = wp;
  while (*wp2 && *wp2 != ' ')
    {
      *wp2 = toupper(*wp2);
      wp2++;
    }
  sprintf(wbuf, "%s \001%s\001", p, wp);
  return cmd_msgnotice("PRIVMSG", wbuf);
}

/* cmd_ping: ping a user */
int
cmd_ping(p)
  char *p;
{
  char buf[512];

  if (!*p)
      return -1;
  if (index(p, ' '))
      return -4;
  sprintf(buf, "%s PING %lu", p, time(NULL));
  return cmd_ctcp(buf);
}

/*
 * basic flood protection stuff.
 * I've always said it's easy, and it is, but this is a simple method
 * which I don't like much.  I'll improve it when I get a chance.
 */
static	time_t	last_t = 0;
static	char	last_cnt;

void
sic_ctcp(nick, toself, txt)
  char *nick, *txt;
  char toself;
{
  char *b, *e, *s;
  int cnt = 0;
  char reply[512] = "", temp[512];

  if ((time(NULL) - last_t) < 10)
    {
      if (++last_cnt >= 3)
	  return;
    }
  else
    {
      last_t = time(NULL);
      last_cnt = 1;
    }

  sprintf(reply, "%s ", nick);
  while (b = index(txt, '\001'))
    {
      if ((e = index(++b, '\001')) == NULL)
	  break;
      if ((s = index(b, ' ')) == NULL)
	  s = e;
      
      *s = '\0';
      temp[0] = '\0';

      if (!strcmp("CLIENTINFO", b))
	  strcpy(temp, "\001CLIENTINFO CLIENTINFO PING TIME VERSION\001");
      else if (!strcmp("PING", b))
	{
	  char *sp = index(s+1, ' ');
	  
	  if (sp && sp < e)
	    {
	      *sp++ = '\001';
	      *sp = '\000';
	    }
          sprintf(temp, "\001PING %s", (s != e) ? s+1 : "");
	}
      else if (!strcmp("TIME", b))
	{
	  char btime[80];
	  time_t t;
	  int gmtoff;
	  struct tm lt, gmt;
	  const char *wday[7]={"Sun", "Mon", "Tue", "Wed", "Thu", "Fri","Sat"};
	  const char *mth[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
				    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

	  t = time(NULL);
 	  lt = *localtime(&t);
 	  gmt = *gmtime(&t);
	  gmtoff = (lt.tm_hour - gmt.tm_hour) * 60 + lt.tm_min - gmt.tm_min;
	  if (lt.tm_year < gmt.tm_year)
	    gmtoff -= 24 * 60;
	  else if (lt.tm_year > gmt.tm_year)
	    gmtoff += 24 * 60;
	  else if (lt.tm_yday < gmt.tm_yday)
	    gmtoff -= 24 * 60;
	  else if (lt.tm_yday > gmt.tm_yday)
	    gmtoff += 24 * 60;

	  sprintf(temp, "\001%s, %d %s %s %2.2d%2.2d\001", wday[lt.tm_wday],
		  lt.tm_mday, mth[lt.tm_mon], my_cftime(btime, 80, "%Y %R", t),
		  (int) (gmtoff/60), (int) (gmtoff%60));
	}
      else if (!strcmp("VERSION", b))
	  sprintf(temp, "\001VERSION sic %s\001", version);

      if (s)
	  if (s == e)
	      *s = '\001';
	  else
	      *s = ' ';

      if (strlen(temp) + strlen(reply) > 256)
	  break;
      strcat(reply, temp);

      if (cnt++ > 4)
	  break;
      txt = e+1;
    }
  if (cnt > 0 && cnt <= 5)
      cmd_msgnotice("NOTICE", reply);
  else
    {
    }
}
