#
#   REMAIL.R
#   Sample programmable mail form for Pegasus Mail v3.0
#   Copright (c) 1993, David Harris, All Rights Reserved.
#
#   You are granted the right to modify and distribute this
#   form in any way you wish provided you do not sell it or
#   any derivative either on its own or as part of any other
#   package.
#
#   By using this form you agree to hold the author blameless
#   for all or any damages or losses resulting from its use.
#
#   This form interfaces with the REMAIL command in Mercury 1.11
#   to allow deferred mail.
#

include defines.rh
include forms.rh

string form_title     "Deferred Message Editor";

window fwindow    # The window in which the form appears
   {
   1, 1, 80, 25, BBLUE | LIGHTGREY | wplain,
   BBLUE | LIGHTGREY, ' ', BSINGLE,
   " Deferred Mail Editing Screen "
   };

block field_text
   {
   2, 1, BBLUE | LIGHTGREY,
   "To   :",
   "Subj :",
   "Cc   :",
   "Defer message until - Year:     Month:     Day:     Hour:     Minute:"
   };

data to         # The "to" field when sending files or messages
   {
   10, 1, 65, 179, 0, 0, 0, GT_STRING, GNOCLEAR
   };

data subject    # The "subject" field when sending files or messages
   {
   10, 2, 63, 64, 0, 0, 0, GT_STRING, 0
   };

data cc         # The "to" field when sending files or messages
   {
   10, 3, 65, 179, 0, 0, 0, GT_STRING, GNOCLEAR
   };

data year
   {
   30, 4, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data month
   {
   41, 4, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data day
   {
   50, 4, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data hour
   {
   60, 4, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data minute
   {
   72, 4, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

text subject_help
   {
   " The Subject Field \n",
   "The subject is a one-line prcis of the contents of the\n",
   "message which will be displayed in the recipient's browse\n",
   "list. You may leave this field blank, but it is considered\n",
   "good e-mail etiquette to provide a meaningful subject."
   };

text time_help
   {
   " Defer message until time \n",
   "Edit this message as you would normally, and set the year, month,\n",
   "day, hour and minute fields to the time when the message should\n",
   "actually be sent. If you set a time in the past, the message will\n",
   "be sent immediately.\n",
   "\n",
   "There are some restrictions on deferred messages:\n",
   "   You can only set To: and CC: addresses\n",
   "   The message may not have attachments\n",
   "   Confirmation of reading and delivery is not supported\n",
   "   Urgent mail is not supported\n",
   "   You must be using the Mercury Transport v1.11 or later.\n",
   "\n",
   "Deferred mailing is intended to let you schedule simple reminder\n",
   "messages or update notices.\n"
   };

line xline_1
   {
   0, 5, 80, 0, LIGHTGREY, ''
   };

line xline_2
   {
   0, 21, 80, 0, LIGHTGREY, ''
   };

line xline_3
   {
   1, 20, 80, 0, BLIGHTGREY, ' '
   };

editor message
   {
   1, 6, 77, 14, 70, 0, 0, BBLUE | LIGHTGREY
   };

block help_text
   {
   1, 22, dim | wcentre,
   "F1-Help  F2-Local user lists  F3-Address books  F6-Distribution lists",
   "F7-File attachments  F9-More options  Ctrl-Enter-Send the message"
   };

string year_dflt               "{year_2}";
string month_dflt              "{nmonth}";
string day_dflt                "{nday}";
string hour_dflt               "{hour}";
string minute_dflt             "{minute}";
string maiser_dflt             "IN:MAISER";
string subject_dflt            "Remail request";

text format
   {
   "Remail {field 12}-{field 13}-{field 14} {field 15}:{field 16}\n",
   "To: {field 9}\n",
   "From: {username}@{domain}\n",
   "Date: {rfc-date}\n",
   "Subject: {field 10}\n",
   "Cc: {field 11}\n",
   "\n",
   "{message}",
   };

formtable formdata
   {
#  Name........ Correlation. Help text.... Validation... Status...... Default
   fwindow,     F_WINDOW,    0,            0,            0,           0,
   0,           F_TO,        0,            0,            0,           maiser_dflt,
   0,           F_SUBJECT,   0,            0,            0,           subject_dflt,
   format,      F_SMTP_TEMPLATE, 0,        0,            0,           0,
   field_text,  0,           0,            0,            0,           0,
   help_text,   0,           0,            0,            0,           0,
   xline_1,     0,           0,            0,            0,           0,
   xline_2,     0,           0,            0,            0,           0,
   xline_3,     0,           0,            0,            0,           0,
   to,          F_STRING,    time_help,    0,            0,           0,
   subject,     F_STRING,    subject_help, 0,            0,           0,
   cc,          F_STRING,    time_help,    0,            0,           0,
   year,        F_INTEGER,   time_help,    0,            0,           year_dflt,
   month,       F_INTEGER,   time_help,    0,            0,           month_dflt,
   day,         F_INTEGER,   time_help,    0,            0,           day_dflt,
   hour,        F_INTEGER,   time_help,    0,            0,           hour_dflt,
   minute,      F_INTEGER,   time_help,    0,            0,           minute_dflt,
   message,     F_MESSAGE,   0,            0,            0,           0
   };

