#
#   TPHONE.R
#   Sample programmable mail form for Pegasus Mail v3.0
#   Copright (c) 1993, David Harris, All Rights Reserved.
#
#   You are granted the right to modify and distribute this
#   form in any way you wish provided you do not sell it or
#   any derivative either on its own or as part of any other
#   package.
#
#   By using this form you agree to hold the author blameless
#   for all or any damages or losses resulting from its use.
#
#   TPHONE is a simple but functional telephone note form
#   for use within PMail.
#

include defines.rh
include forms.rh

string form_title     "Telephone message form";

window fwindow    # The window in which the form appears
   {
   24, 4, 53, 19, BLIGHTGREY | RED | wshadow | wplain,
   BLIGHTGREY | BLUE, ' ', BSINGLE,
   " Telephone message "
   };

block field_text
   {
   3, 1, BLIGHTGREY | BLUE,
   "To:",
   "at {hour}:{minute}, ",
   "of:",
   "ph:",
   " -                      and:"
   };

data to           # The "to" field for the message
   {
   8, 1, 38, 179, YELLOW, LIGHTBLUE, 0, GT_STRING, 0
   };

data caller       # The name of the person who called
   {
   17, 2, 27, 80, YELLOW, LIGHTBLUE, 0, GT_STRING, 0
   };

data of           # The "of" field on the phone form
   {
   8, 3, 38, 80, YELLOW, LIGHTBLUE, 0, GT_STRING, 0
   };

data phone        # The "phone number" field on the phone form
   {
   8, 4, 36, 80, YELLOW, LIGHTBLUE, 0, GT_STRING, 0
   };

menu action_menu
   {
   4, 0, 0, 0, 0;

   1, 1, 0, 'T', 0, "Telephoned",
   1, 2, 0, 'D', 1, "Dropped in",
   1, 3, 0, 'R', 2, "Returned your call",
   1, 3, 0, 'F', 3, "Faxed you",
   };

popup_menu what
   {
   action_menu, 0, 0, 8, 5, 
   BBLUE | YELLOW | wshadow, BLIGHTGREY | LIGHTBLUE
   };

menu title_menu
   {
   4, 0, 0, 0, 0;

   1, 1, 0, 'M', 0, "Mr",
   1, 2, 0, 'R', 1, "Mrs",
   1, 3, 0, 'S', 2, "Ms",
   1, 4, 0, 'D', 3, "Dr"
   };

popup_menu title
   {
   title_menu, 0, 0, 13, 2,
   BBLUE | YELLOW | wshadow, BLIGHTGREY | LIGHTBLUE
   };

menu wants_menu
   {
   4, 0, 0, 0, 0;

   1, 1, 0, 'P', 0, "Wants you to call",
   1, 2, 0, 'W', 1, "Will call again",
   1, 3, 0, 'C', 2, "Call urgently",
   1, 4, 0, 'O', 3, "Other (see below)"
   };

popup_menu wants
   {
   wants_menu, 0, 0, 33, 5, 
   BBLUE | YELLOW | wshadow, BLIGHTGREY | LIGHTBLUE
   };

text hlp_to       # Help field for the to: field
   {
   "To field\n",
   "\n",
   "Enter in this field the e-mail address of the\n",
   "person to whom this notification is being sent.\n",
   "\n",
   " Press <F2> for a list of local e-mail users.\n",
   " Press <F3> to access your address books.\n",
   " Press <F6> to access mail distribution lists.\n",
   "\n",
   "If you want to cancel the message at any time,\n",
   "press the <Esc> key.\n"
   }

text hlp_title
   {
   " Caller's Title \n",
   "Press <Enter> here to open a popup menu\n",
   "from which you can choose the title most\n",
   "appropriate for the caller.",
   }

text hlp_name     # Help field for the of: field
   {
   "Name field\n",
   "Enter here the name of the person who is leaving\n",
   "the phone message\n",
   "\n",
   "If you want to cancel the message at any time,\n",
   "press the <Esc> key."
   }

text hlp_of       # Help field for the of: field
   {
   " Of field \n",
   "Enter in this field the name of the company or\n",
   "Organization the caller represents. You can leave\n",
   "this field blank if you wish.\n",
   "\n",
   "If you want to cancel the message at any time,\n",
   "press the <Esc> key."
   }

text hlp_what     # Help for the "what he did" popup menu
   {
   " Caller's Action \n"
   "Select from this menu the means the caller\n"
   "used to make contact - namely, whether the\n",
   "caller phoned, dropped in or sent a fax."
   };

text hlp_wants    # Help for the "what he should do" popup menu
   {
   " Requested Action \n"
   "Press <Enter> here to open a popup-menu listing the\n",
   "action the caller requests the recipient should take\n",
   "regarding this message.\n",
   "\n"
   "Highlight the most appropriate choice in the list and\n",
   "press <Enter>. If nothing in the list is appropriate,\n",
   "you can go into more detail in the message body."
   };

text hlp_phone    # Help for the "phone number" popup menu
   {
   "Phone number\n"
   "\n",
   "Enter the caller's contact phone number\n",
   "in this field."
   "\n"
   };

text val_address         # Generic address validation routine
   {
   "Must be valid address\n"
   };

line xline_1
   {
   0, 6, 60, 0, RED, ''
   };

line xline_2
   {
   0, 14, 60, 0, RED, ''
   };

box status
   {
   3, 15, 42, 3, 0, BLACK | BLIGHTGREY
   };

editor message
   {
   1, 7, 48, 6, 48, 50, 2000, BLUE | BLIGHTGREY
   };


block to_txt
   {
   0, 0, 0,
   "Enter the name of the person to whom this",
   "phone message should be sent."
   };

block title_txt
   {
   0, 0, 0,
   "Press <Enter> to select the title of the",
   "person leaving the message, or use the",
   "arrow keys to move on."
   };

block caller_txt
   {
   0, 0, 0,
   "Enter the name of the person leaving the",
   "message in this field."
   };

block of_txt
   {
   0, 0, 0,
   "Enter the name of the organization which",
   "the person leaving the message represents",
   "(optional)."
   };

block phone_txt
   {
   0, 0, 0,
   "Enter here the phone number of the person",
   "leaving the message."
   };

block what_txt
   {
   0, 0, 0,
   "Press <Enter> to choose from a menu of",
   "choices describing how the caller got in",
   "contact."
   };

block wants_txt
   {
   0, 0, 0,
   "Press <Enter> to select the action the",
   "recipient is asked to take regarding this",
   "message."
   };

block message_txt
   {
   0, 0, 0,
   "Edit any extra message details you need to",
   "add in this field. Press <Ctrl-Enter> once",
   "you have finished preparing the message."
   };


##  The next record is the formatting record for this form - it controls
##  how the information is output into the message generated when the
##  form is sent.

text format
   {
   "\n",
   "     T e l e p h o n e  M e s s a g e Ŀ\n",
   "                                                               \n",
   "      To: {to}{tab 32}  From: {servername}/{username} {tab 64}\n",
   "                                                               \n",
   "      {field 11} {field 12} of {field 13}{tab 64}\n",
   "      {field 15} at {rfc-date} (id: {field 5}){tab 64}\n",
   "                                                               \n",
   "      ** {field 16} **{tab 39}ph: {field 14}{tab 64}\n",
   "                                                               \n",
   "    \n",
   "\n",
   "     Message \n",
   "\n",
   "    {message}\n",
   };


string subject_string      "Telephone message";
string serial_string       "{serial ~a/forms/serial}";

formtable formdata
   {
#  Name........ Correlation. Help text.... Validation... Status...... Default
   fwindow,     F_WINDOW,    0,            0,            0,           0,
   status,      F_STATUS,    0,            0,            0,           0,
   field_text,  0,           0,            0,            0,           0,
   xline_1,     0,           0,            0,            0,           0,
   xline_2,     0,           0,            0,            0,           0,
   0,           F_STRING,    0,            0,            0,           serial_string,
   0,           F_SUBJECT,   0,            0,            0,           subject_string,
   0,           F_NOSIG,     0,            0,            0,           1,
   0,           F_COPYSELF,  0,            0,            0,           0,
   format,      F_SMTP_TEMPLATE, 0         0,            0,           0
   to,          F_TO,        hlp_to,       val_address,  to_txt,      0,
   title,       F_STRING,    hlp_title,    0,            title_txt,   0,
   caller,      F_STRING,    hlp_name,     0,            caller_txt,  0,
   of,          F_STRING,    hlp_of,       0,            of_txt,      0,
   phone,       F_STRING,    hlp_phone,    0,            phone_txt,   0,
   what,        F_STRING,    hlp_what,     0,            what_txt,    0,
   wants,       F_STRING,    hlp_wants,    0,            wants_txt,   0,
   message,     F_MESSAGE,   0,            0,            message_txt, 0
   };

