/*
 * Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University
 * in the City of New York.  Permission is granted to any individual or
 * institution to use, copy, or redistribute this software so long as it
 * is not sold for profit, provided this copyright notice is retained.
 */

#ifndef lint
static char *rcsid = "$Header: cmds.c,v 1.53 88/07/21 18:32:16 howie Exp $";
#endif

/*
 * cmds.c - top level command tables for mm
 *
 * All of the top-level command tables for mm are declared here.
 */

#include "mm.h"
#include "parse.h"
#include "cmds.h"
#include "rd.h"


/*
 * abbreviations for top level mm commands
 */

keywrd mm_top_abbr_keys[] = {
    { "delete", KEY_INV, (keyval) CMD_DELETE },	  /* 0 */
    { "exit", KEY_INV, (keyval) CMD_EXIT },	  /* 1 */
    { "headers", KEY_INV, (keyval) CMD_HEADERS }, /* 2 */
    { "literal", KEY_INV, (keyval) CMD_LITERAL }, /* 3 */
    { "previous", KEY_INV, (keyval) CMD_PREVIOUS }, /* 4 */
    { "quit", KEY_INV, (keyval) CMD_QUIT }, 	  /* 5 */
    { "read", KEY_INV, (keyval) CMD_READ },	  /* 6 */
    { "send", KEY_INV, (keyval) CMD_SEND },	  /* 7 */
    { "type", KEY_INV, (keyval) CMD_TYPE },  	  /* 8 */
    { "undelete", KEY_INV, (keyval) CMD_UNDELETE }, /* 9 */
};

keytab mm_top_abbr_keytab = { sizeof (mm_top_abbr_keys) / sizeof (keywrd),
			      mm_top_abbr_keys };
fdb mm_top_abbr_fdb = { _CMKEY, CM_SDH, nil, (pdat) &mm_top_abbr_keytab, 
			  NULL };

/*
 * top level mm commands
 */

keywrd mm_top_keys[] = {
    { "alias", 0, (keyval) CMD_ALIAS },
    { "answer", 0, (keyval) CMD_ANSWER },
    { "blank", 0, (keyval) CMD_BLANK },
    { "browse", 0, (keyval) CMD_BROWSE },
    { "bug", 0, (keyval) CMD_BUG },
    { "cd", 0, (keyval) CMD_CD },
    { "check", 0, (keyval) CMD_CHECK },
    { "continue", 0, (keyval) CMD_CONTINUE },
    { "copy", 0, (keyval) CMD_COPY },
    { "count", 0, (keyval) CMD_COUNT },
    { "create-init", 0, (keyval) CMD_CREATE_INIT },
    { "daytime", 0, (keyval) CMD_DAYTIME },
    { "debug", KEY_INV, (keyval) CMD_DEBUG },
    { "debug-memory", KEY_INV, CMD_MEMDEBUG },
    { "define", 0, (keyval) CMD_DEFINE },
    { "delete", 0, (keyval) CMD_DELETE },
    { "echo", 0, (keyval) CMD_ECHO },
    { "edit", 0, (keyval) CMD_EDIT },
    { "examine", 0, (keyval) CMD_EXAMINE },
    { "exit", 0, (keyval) CMD_EXIT },
    { "expunge", 0, (keyval) CMD_EXPUNGE },
    { "flag", 0, (keyval) CMD_FLAG },
    { "forward", 0, (keyval) CMD_FORWARD },
    { "get", 0, (keyval) CMD_GET },
    { "headers", 0, (keyval) CMD_HEADERS },
    { "help", 0, (keyval) CMD_HELP },
    { "jump", 0, (keyval) CMD_JUMP },
    { "keyword", 0, (keyval) CMD_KEYWORD },
    { "list", 0, (keyval) CMD_LIST },
    { "literal", 0, (keyval) CMD_LITERAL },
    { "mail", 0, (keyval) CMD_SEND },
    { "mark", 0, (keyval) CMD_MARK },
    { "move", 0, (keyval) CMD_MOVE },
    { "next", 0, (keyval) CMD_NEXT },
    { "previous", 0, (keyval) CMD_PREVIOUS },
    { "print", 0, (keyval) CMD_PRINT },
    { "profile", 0, (keyval) CMD_PROFILE },
    { "push", 0, (keyval) CMD_PUSH },
    { "pwd", 0, (keyval) CMD_PWD },
    { "quit", 0, (keyval) CMD_QUIT },
    { "qquit", 0, (keyval) CMD_QQUIT },
    { "read", 0, (keyval) CMD_READ },
    { "remail", 0, (keyval) CMD_REMAIL },
    { "reply", 0, (keyval) CMD_REPLY },
    { "restore-draft", 0, (keyval) CMD_RESTORE_DRAFT },
    { "route", 0 , (keyval) CMD_ROUTE },
    { "send", 0, (keyval) CMD_SEND },
    { "set", 0, (keyval) CMD_SET },
    { "show", 0, (keyval) CMD_SHOW },
    { "sort", 0, (keyval) CMD_SORT },
    { "spell", 0, (keyval) CMD_SPELL },
    { "status", 0, (keyval) CMD_STATUS },
    { "suspend", 0, (keyval) CMD_SUSPEND },
    { "take", 0, (keyval) CMD_TAKE },
    { "type", 0, (keyval) CMD_TYPE },
    { "unanswer", 0, (keyval) CMD_UNANSWER },
    { "undelete", 0, (keyval) CMD_UNDELETE },
    { "unflag", 0, (keyval) CMD_UNFLAG },
    { "unkeyword", 0, (keyval) CMD_UNKEYWORD },
    { "unmark", 0, (keyval) CMD_UNMARK },
    { "version", 0, (keyval) CMD_VERSION },
    { "who", 0, (keyval) CMD_WHO },
    { "write", 0, (keyval) CMD_WRITE },
    { "z", KEY_INV, (keyval) CMD_Z },
};
keytab mm_top_keytab = { sizeof (mm_top_keys) / sizeof (keywrd), mm_top_keys };
fdb mm_top_fdb = { _CMKEY, 0, nil, (pdat) &mm_top_keytab, "command, " };


/*
 * read mode command abbreviations
 */

keywrd read_abbr_keys[] = {
    { "delete", KEY_INV, (keyval) CMD_DELETE }, /* 0 */
    { "headers", KEY_INV, (keyval) CMD_HEADERS }, /* 1 */
    { "kill", KEY_INV, (keyval) CMD_KILL },
    { "literal", KEY_INV, (keyval) CMD_LITERAL },
    { "move", KEY_INV, (keyval) CMD_MOVE },	/* 2 */
    { "previous", KEY_INV, (keyval) CMD_PREVIOUS }, /* 3 */
    { "reply", KEY_INV, (keyval) CMD_REPLY },	/* 4 */
    { "send", KEY_INV, (keyval) CMD_SEND },	/* 5 */
    { "type", KEY_INV, (keyval) CMD_TYPE },	/* 6 */
    { "undelete", KEY_INV, (keyval) CMD_UNDELETE }, /* 7 */
};
keytab read_abbr_keytab = {
    sizeof (read_abbr_keys) / sizeof (keywrd), read_abbr_keys
};
fdb read_abbr_fdb = { _CMKEY, CM_SDH, nil, (pdat) &read_abbr_keytab,
			nil, nil, nil };


/*
 * read commands
 */

keywrd read_keys[] = {
    { "answer", 0, (keyval) CMD_ANSWER },
    { "blank", 0, (keyval) CMD_BLANK },
    { "browse", 0, (keyval) CMD_BROWSE },
    { "bug", 0, (keyval) CMD_BUG },
    { "cd", 0, (keyval) CMD_CD },
    { "check", 0, (keyval) CMD_CHECK },
    { "continue", 0, (keyval) CMD_CONTINUE },
    { "copy", 0, (keyval) CMD_COPY },
    { "create-init", 0, (keyval) CMD_CREATE_INIT },
    { "daytime", 0, (keyval) CMD_DAYTIME },
    { "debug", KEY_INV, (keyval) CMD_DEBUG },
    { "debug-memory", KEY_INV, (keyval) CMD_MEMDEBUG },
    { "define", 0, (keyval) CMD_DEFINE },
    { "delete", 0, (keyval) CMD_DELETE },
    { "echo", 0, (keyval) CMD_ECHO },
    { "edit", 0, (keyval) CMD_EDIT },
    { "examine", 0, (keyval) CMD_EXAMINE },
    { "exit", 0, (keyval) CMD_EXIT },
    { "flag", 0, (keyval) CMD_FLAG },
    { "follow", 0, (keyval) CMD_FOLLOW },
    { "forward", 0, (keyval) CMD_FORWARD },
    { "get", 0, (keyval) CMD_GET },
    { "headers", 0, (keyval) CMD_HEADERS },
    { "help", 0, (keyval) CMD_HELP },
    { "jump", 0, (keyval) CMD_JUMP },
    { "keyword", 0, (keyval) CMD_KEYWORD },
    { "kill", 0, (keyval) CMD_KILL },
    { "list", 0, (keyval) CMD_LIST },
    { "literal", 0, (keyval) CMD_LITERAL },
    { "mail", 0, (keyval) CMD_SEND },
    { "mark", 0, (keyval) CMD_MARK },
    { "move", 0, (keyval) CMD_MOVE },
    { "next", 0, (keyval) CMD_NEXT },
    { "previous", 0, (keyval) CMD_PREVIOUS },
    { "print", 0, (keyval) CMD_PRINT },
    { "profile", 0, (keyval) CMD_PROFILE },
    { "push", 0, (keyval) CMD_PUSH },
    { "pwd", 0, (keyval) CMD_PWD },
    { "quit", 0, (keyval) CMD_QUIT },
    { "remail", 0, (keyval) CMD_REMAIL },
    { "reply", 0, (keyval) CMD_REPLY },
    { "restore-draft", 0, (keyval) CMD_RESTORE_DRAFT },
    { "route", 0 , (keyval) CMD_ROUTE },
    { "send", 0, (keyval) CMD_SEND },
    { "set", 0, (keyval) CMD_SET },
    { "show", 0, (keyval) CMD_SHOW },
    { "spell", 0, (keyval) CMD_SPELL },
    { "status", 0, (keyval) CMD_STATUS },
    { "suspend", 0, (keyval) CMD_SUSPEND },
    { "take", 0, (keyval) CMD_TAKE },
    { "type", 0, (keyval) CMD_TYPE },
    { "unanswer", 0, (keyval) CMD_UNANSWER },
    { "undelete", 0, (keyval) CMD_UNDELETE },
    { "unflag", 0, (keyval) CMD_UNFLAG },
    { "unkeyword", 0, (keyval) CMD_UNKEYWORD },
    { "unmark", 0, (keyval) CMD_UNMARK },
    { "version", 0, (keyval) CMD_VERSION },
    { "who", 0, (keyval) CMD_WHO },
    { "write", 0, (keyval) CMD_WRITE },
    { "z", KEY_INV, (keyval) CMD_Z },
};
keytab read_keytab = {
    sizeof (read_keys) / sizeof (keywrd), read_keys
};
fdb read_fdb = { _CMKEY, nil, nil, (pdat) &read_keytab,
		      "Read command, ", nil, nil };

/*
 * send mode command abbreviations
 */

keywrd send_abbr_keys[] = {
    { "display", KEY_INV, (keyval) CMD_DISPLAY }, /* 0 */
    { "edit", KEY_INV, (keyval) CMD_EDIT },	/* 1 */
    { "headers", KEY_INV, (keyval) CMD_HEADERS }, /* 2 */
    { "literal", KEY_INV, (keyval) CMD_LITERAL },
    { "remove", KEY_INV, (keyval) CMD_REMOVE }, /* 3 */
    { "send", KEY_INV, (keyval) CMD_SEND },	/* 4 */
    { "type", KEY_INV, (keyval) CMD_TYPE },	/* 5 */
};
keytab send_abbr_keytab = {
    sizeof (send_abbr_keys) / sizeof (keywrd), send_abbr_keys
};
fdb send_abbr_fdb = { _CMKEY, CM_SDH, nil, (pdat) &send_abbr_keytab,
			nil, nil, nil };


/*
 * send mode commands 
 */

keywrd send_keys[] = {
    { "blank", 0, (keyval) CMD_BLANK },
    { "cd", 0, (keyval) CMD_CD },
    { "check", 0, (keyval) CMD_CHECK },
    { "copy", 0, (keyval) CMD_COPY },
    { "count", 0, (keyval) CMD_COUNT },
    { "create-init", 0, (keyval) CMD_CREATE_INIT },
    { "daytime", 0, (keyval) CMD_DAYTIME },
    { "debug", KEY_INV, (keyval) CMD_DEBUG },
    { "debug-memory", KEY_INV, (keyval) CMD_MEMDEBUG },
    { "define", 0, (keyval) CMD_DEFINE },
    { "delete", 0, (keyval) CMD_DELETE },
    { "display", 0, (keyval) CMD_DISPLAY },
    { "echo", 0, (keyval) CMD_ECHO },
    { "edit", 0, (keyval) CMD_EDIT },
    { "erase", 0, (keyval) CMD_ERASE },
    { "expunge", 0, (keyval) CMD_EXPUNGE },
    { "flag", 0, (keyval) CMD_FLAG },
    { "insert", 0, (keyval) CMD_INSERT },
    { "headers", 0, (keyval) CMD_HEADERS },
    { "help", 0, (keyval) CMD_HELP },
    { "jump", 0, (keyval) CMD_JUMP },
    { "keyword", 0, (keyval) CMD_KEYWORD },
    { "list", 0, (keyval) CMD_LIST },
    { "literal", 0, (keyval) CMD_LITERAL },
    { "mark", 0, (keyval) CMD_MARK },
    { "move", 0, (keyval) CMD_MOVE },
    { "print", 0, (keyval) CMD_PRINT },
    { "profile", 0, (keyval) CMD_PROFILE },
    { "push", 0, (keyval) CMD_PUSH },
    { "pwd", 0, (keyval) CMD_PWD },
    { "quit", 0, (keyval) CMD_QUIT },
    { "read", 0, (keyval) CMD_READ },
    { "remove", 0, (keyval) CMD_REMOVE },
    { "route", 0 , (keyval) CMD_ROUTE },
    { "save-draft", 0, (keyval) CMD_SAVE_DRAFT },
    { "send", 0, (keyval) CMD_SEND },
    { "set", 0, (keyval) CMD_SET },
    { "show", 0, (keyval) CMD_SHOW },
    { "spell", 0, (keyval) CMD_SPELL },
    { "status", 0, (keyval) CMD_STATUS },
    { "suspend", 0, (keyval) CMD_SUSPEND },
    { "take", 0, (keyval) CMD_TAKE },
    { "type", 0, (keyval) CMD_TYPE },
    { "unanswer", 0, (keyval) CMD_UNANSWER },
    { "undelete", 0, (keyval) CMD_UNDELETE },
    { "unflag", 0, (keyval) CMD_UNFLAG },
    { "unkeyword", 0, (keyval) CMD_UNKEYWORD },
    { "unmark", 0, (keyval) CMD_UNMARK },
    { "version", 0, (keyval) CMD_VERSION },
    { "who", 0, (keyval) CMD_WHO },
    { "write", 0, (keyval) CMD_WRITE },
    { "z", KEY_INV, (keyval) CMD_Z },
};
keytab send_keytab = {
    sizeof (send_keys) / sizeof (keywrd), send_keys
};
fdb send_fdb = { _CMKEY, nil, nil, (pdat) &send_keytab, 
			"Send command, ", nil, nil };


/* 
 * Keyword table for modifying header fields
 */

keywrd hdr_keys[] = {
    { "bcc", 0, (keyval) CMD_BCC },
    { "cc", 0, (keyval) CMD_CC },
    { "fcc", 0, (keyval) CMD_FCC },
    { "from", 0, (keyval) CMD_FROM },
    { "in-reply-to", 0, (keyval) CMD_IN_REPLY_TO },
    { "reply-to", 0, (keyval) CMD_REPLY_TO },
    { "subject", 0, (keyval) CMD_SUBJECT },
    { "text", 0, (keyval) CMD_TEXT },
    { "to", 0, (keyval) CMD_TO },
    { "user-header", 0, (keyval) CMD_USER_HEADER }
};

keytab hdr_keytab = { sizeof (hdr_keys) / sizeof (keywrd), hdr_keys };
fdb hdr_cmd_fdb = { _CMKEY, 0, nil, (pdat) &hdr_keytab, "header field, " };

keywrd disp_keys[] = {
    { "all", 0, (keyval) CMD_ALL },
    { "header", 0, (keyval) CMD_HEADER },
};

keytab disp_keytab = { sizeof (disp_keys) / sizeof (keywrd), disp_keys};
fdb disp_cmd_fdb = { _CMKEY, 0, nil, (pdat) &disp_keytab, NULL, "all" };

keywrd erase_keys[] = {
    { "all", 0, (keyval) CMD_ALL },
};
keytab erase_keytab = { sizeof (erase_keys) / sizeof (keywrd), erase_keys};
fdb erase_cmd_fdb = { _CMKEY, 0, nil, (pdat) &erase_keytab, NULL, "text" };

keywrd reply_to_keys[] = {
    { "all", 0, (keyval) CMD_ALL },
    { "none", 0, (keyval) CMD_QUIT },	/* temporary way to abort */
    { "sender", 0, (keyval) CMD_SENDER },
};
keytab reply_to_keytab = { sizeof(reply_to_keys)/sizeof(keywrd),
			       reply_to_keys};
fdb reply_to_fdb = { _CMKEY, 0, nil,  (pdat) &reply_to_keytab, NULL, "sender"};

keywrd include_keys[] = {
    { "including", 0, (keyval) CMD_INCLUDE },
    { "not-including", 0, (keyval) CMD_NOINCLUDE },
};
keytab include_keytab = { sizeof(include_keys)/sizeof(keywrd),
			       include_keys};
fdb include_fdb = { _CMKEY, 0, nil,  (pdat) &include_keytab, NULL,
			"not-including"};

int
nocmd(n)
int n;
{
    confirm ();
    printf ("Sorry, this command is not yet implemented.\n");
}

/*
 * This array is indexed by the main parse loop to dispatch to the
 * appropriate handler routine for each routine.
 */

int nocmd (),
    cmd_alias(),
    cmd_bcc (),
    cmd_blank (),
    cmd_browse (),
    cmd_bug (),
    cmd_cc (),
    cmd_cd (),
    cmd_check (),
    cmd_continue(),
    cmd_copy(),
    cmd_count(),
    cmd_create_init(),
    cmd_next(),
    cmd_daytime (),
    cmd_debug (),
    cmd_debug_memory (),
    cmd_define (),
    cmd_display (),
    cmd_echo (),
    cmd_edit(),
    cmd_erase(),
    cmd_exit (),
    cmd_expunge (),
    cmd_fcc(),
    cmd_forward(), 
    cmd_from (),
    cmd_get (),
    cmd_headers (),
    cmd_help(),
    cmd_in_reply_to(),
    cmd_insert(),
    cmd_jump(),
    cmd_keyword(),
    cmd_list(),
    cmd_literal(),
    cmd_mark (),
    cmd_next (),
    cmd_previous (),
    cmd_print(),
    cmd_profile (),
    cmd_push (),
    cmd_pwd(),
    cmd_quit (),
    cmd_read (),
    cmd_remail(),
    cmd_remove (),
    cmd_reply(),
    cmd_reply_to(),
    cmd_restore_draft(),
    cmd_route(),
    cmd_save_draft(),
    cmd_send (),
    cmd_set (),
    cmd_show (),
    cmd_sort (),
    cmd_spell (),
    cmd_status (), 
    cmd_subject (),
    cmd_suspend (),
    cmd_take (), 
    cmd_text (),
    cmd_to (),
    cmd_type (),
    cmd_unkeyword (),
    cmd_user_header (),
    cmd_version (),
    cmd_who(),
    cmd_write();

int (*mm_cmds[])() = {
    cmd_alias,			/* CMD_ALIAS */
    cmd_reply,			/* CMD_ANSWER */
    cmd_bcc,			/* CMD_BCC */
    cmd_blank,			/* CMD_BLANK */
    cmd_browse,			/* CMD_BROWSE */
    cmd_bug,			/* CMD_BUG */
    cmd_cc,			/* CMD_CC */
    cmd_cd,			/* CMD_CD */
    cmd_check,			/* CMD_CHECK */
    cmd_continue,		/* CMD_CONTINUE */
    cmd_copy,			/* CMD_COPY */
    cmd_count,			/* CMD_COUNT */
    cmd_create_init,		/* CMD_CREATE_INIT */
    cmd_daytime,		/* CMD_DAYTIME */
    cmd_debug,			/* CMD_DEBUG */
    cmd_debug_memory,		/* CMD_MEMDEBUG */
    cmd_define,			/* CMD_DEFINE */
    cmd_mark,			/* CMD_DELETE */
    cmd_display,		/* CMD_DISPLAY */
    cmd_echo,			/* CMD_ECHO */
    cmd_edit,			/* CMD_EDIT */
    cmd_erase,			/* CMD_ERASE */
    cmd_get,			/* CMD_EXAMINE */
    cmd_exit,			/* CMD_EXIT */
    cmd_expunge,		/* CMD_EXPUNGE */
    cmd_fcc,			/* CMD_FCC */
    cmd_mark,			/* CMD_FLAG */
    nocmd,			/* CMD_FOLLOW */
    cmd_forward,		/* CMD_FORWARD */
    cmd_from,			/* CMD_FROM */
    cmd_get,			/* CMD_GET */
    cmd_headers,		/* CMD_HEADERS */
    cmd_help,			/* CMD_HELP */
    cmd_insert,			/* CMD_INSERT */
    cmd_in_reply_to,		/* CMD_IN_REPLY_TO */
    cmd_jump,			/* CMD_JUMP */
    cmd_keyword,		/* CMD_KEYWORD */
    cmd_next,			/* CMD_KILL */
    cmd_list,			/* CMD_LIST */
    cmd_literal,		/* CMD_LITERAL */
    cmd_mark,			/* CMD_MARK */
    cmd_copy,			/* CMD_MOVE */
    cmd_next,			/* CMD_NEXT */
    cmd_previous,		/* CMD_PREVIOUS */
    cmd_print,			/* CMD_PRINT */
    cmd_profile,		/* CMD_PROFILE */
    cmd_push,			/* CMD_PUSH */
    cmd_pwd,			/* CMD_PWD */
    cmd_quit,			/* CMD_QUIT */
    cmd_quit,			/* CMD_QQUIT */
    cmd_read,			/* CMD_READ */
    cmd_remail,			/* CMD_REMAIL */
    cmd_remove,			/* CMD_REMOVE */
    cmd_reply,			/* CMD_REPLY */
    cmd_reply_to,		/* CMD_REPLY_TO */
    cmd_restore_draft,		/* CMD_RESTORE_DRAFT */
    cmd_route,			/* CMD_ROUTE */
    cmd_save_draft,		/* CMD_SAVE_DRAFT */
    cmd_send,			/* CMD_SEND */
    cmd_set,			/* CMD_SET */
    cmd_show,			/* CMD_SHOW */
    cmd_sort,			/* CMD_SORT */
    cmd_spell,			/* CMD_SPELL */
    cmd_status,			/* CMD_STATUS */
    cmd_subject,		/* CMD_SUBJECT */
    cmd_suspend,		/* CMD_SUSPEND */
    cmd_take,			/* CMD_TAKE */
    cmd_text,			/* CMD_TEXT */
    cmd_to,			/* CMD_TO */
    cmd_type,			/* CMD_TYPE */
    cmd_mark,			/* CMD_UNANSWER */
    cmd_mark,			/* CMD_UNDELETE */
    cmd_mark,			/* CMD_UNFLAG */
    cmd_unkeyword,		/* CMD_UNKEYWORD */
    cmd_mark,			/* CMD_UNMARK */
    cmd_user_header,		/* CMD_USER_HEADER */
    cmd_version,		/* CMD_VERSION */
    cmd_who,			/* CMD_WHO */
    cmd_write,			/* CMD_WRITE */
    cmd_suspend,		/* CMD_Z */
};
