.TH EMIL.CF 8 "19 December 1994"
.SH NAME
emil.cf \- configuration file for emil(8)
.SH SYNOPSIS
.B group
.IR  "Group_Name" ":" 
.RB  "[\ " "charset="
.IR  "CHARSET"
.IR  "," "\ ]"
.RB  "[\ " "format="
.IR  "FORMAT"
.IR  "," "\ ]"
.RB  "[\ " "bin="
.IR  "ENCODING"
.IR  "," "\ ]"
.RB  "[\ " "textenc="
.IR  "ENCODING" 
.IR  "," "\ ]"
.RB  "[\ " "henc="
.IR  "ENCODING" "\ ]"
.IR ";"

.B match
.IR "Context" 
.IR "\ Match_String"
.IR "\ OUT" 
.RB ";"

.B member
.IR "Group_Name" "\ :\ "
.IR "Recipient" "\ "
.IR "Sender" "\ "
.IR "Recipient_host" 
.RB "\ ," "\ ... " ";"

.B mailer
.IR "Mailer_Name" "\ :\ "
.IR "Path," "\ "
.IR "Program," "\ "
.IR "Arguments," 
.RB "\ ... " ";"
.SH DESCRIPTION
The file 
MAINCF
is used by emil(8) to decide which conversions should be applied to a specific
Internet 
message. Conversion is controlled by the combination of 
.IR Sender,
.IR Recipient
and
.IR "Recipient_host"
and the corresponding
.RB "group"
line.

When emil is executed it first visits 
MAINCF
with the arguments
.IR Sender,
.IR Recipient
and
.IR "Recipient_host" 
to extract the name of target group (as specified by the 
.B member
fields). A subsequent check with the
.B group
fields yields the target group structure, containing
.IR "charset,"
.IR "format,"
.IR "bin,"
.IR "textenc"
and
.IR "henc."
Then the
.IR "Sender"
and
.IR "Recipient"
is swapped to get the corresponding information about the sender.

.SH COMMANDS
.LP
Commands may appear in any order. They are all ended with a
semi colon ";".
.RS
.TP
.B "group" 
Defines a group by a group name and a comma separated list of
options.

.IR "Group_name"
- Name of the group.

.RB charset
- Specifies the charset used by the group, according to RFC1345.

.RB format
- Specifies the format used by the group.
Pick one of: MIME, MAILTOOL, RFC822 or TRANSPARENT.
Default is RFC822.

.RB bin
- Specifies the encoding to be used for binary attachments.
Pick one of BAse64, BInhex or Uuencode.

.RB textenc
- Specifies the encoding to be used for text.
Pick one of BAse64, BInhex, Uuencode, Quoted-printable, 8bit
or 7bit. 7bit is default. When 7bit is chosen the text is
first converted to ISO-8859-1 and then the 8bit characters
are replaced by the appropriate characters as specified by
some national variants of ISO-646. This special conversion
is suited to work in Sweden but works probably also for other
european languages.

.RB henc
- Specifies the encoding to be used for header lines.
Pick one of Base64, Quoted-printable, 8bit or 7bit.
7bit is default. If BAse64 or Quoted-Printable is selected
headers are converted according to RFC1522 (MIME-II).
If 7bit is selected headers are first converted to ISO-8859-1
and then 8bit characters are converted to the US-ASCII
characters of closest resemblance.

.TP
.B "match"
This field is used to build a list of types and the
corresponding expression in the given context.
.RS

.IR Context
- One of MIME, BINHEX or UUENCODE.

.IR OUT
- The generic type of the field

.IR Match_String
- A quoted string that corresponds to the 
.IR Context
of the field. For MIME
.IR Match_String
defines the content-type to be used. For UUENCODE 
.IR Match_String
defines the file name extension to be used.
For BINHEX
.IR Match_String
defines the merged two 4byte strings Type and Auth info.

.RE
.TP 
.B "member " 
Defines members of a group given as a group name and a comma
separated list of the triples 
.IR Recipient,
.IR Sender
and
.IR Recipient_host.
Either one in the triples can be totally or partly replaced by a wildcard '*'.

.IR "Group_name"
- Name of the group.
.RS

.IR Sender
- Sender's mail address.

.IR Recipient
- Recipient's mail address.

.IR Recipient_host
- Name of the recipient host or relay.
.RE
.RE
.TP 
.B "mailer " 
Defines a mailer (or tags a program) as a mailer name and a comma
separated list of arguments that makes up the execv vector of the
program to execute.

.IR "Mailer_name"
- Name of the mailer.
.RS

.IR Path
- Path of the program to execute.

.IR Program
- Name of the program to execute

.IR Arguments
- A list of each command line argument to use when invoking the program.
To be suitable for mail programs you can specify variables representing
sender and recipient. These are specified by $s and $r respectively.
.RE
.SH AUTHOR
Martin Wendel (Martin.Wendel@udac.uu.se) and
Torbjorn Wictorin (Torbjorn.Wictorin@udac.uu.se)
.SH "SEE ALSO"
emil(8)
.SH BUGS
None




