# dis
#
# 30-June-92 jay@eitech.com
#
# This service will access DIS, the Distributed Information Service.
# The input is the language-independent version of DIS, e.g. (object? foo)
# one command per line and the results will be returned in a similar fashion
# The answers can either be 1) separate, in which case the response is a
# multipart message where the first part are the results and the
# second part is the corresponding commands; or 2) interspersed, in
# which case the resulting message alternates commands with the results

proc dodis { switches envelope inputs } {

#    if { ! [local [getfield $envelope FROM]] } {
#		setfield response STRING "Sorry, this service is only provided for local users"
#		return [mailout [turnaround $envelope] $response]
#	}

    ## where the commands are
    set src [getfield $inputs FILE]

    set interspersed 1
    set server default
    set port default

    if { [llength $switches] != 0 } {
	if { [lsearch $switches separate] >= 0 } {
		set interspersed 0
	}
	if { [set i [lsearch $switches server]] >= 0 } {
		set server [lindex $switches [expr $i+1]]
	}
	if { [set i [lsearch $switches port]] >= 0 } {
		set port [lindex $switches [expr $i+1]]
	}
    }

    catch "exec smdis $src -i $interspersed -s $server -p $port > $src.out"
    # for testing
    #	set fid [open $src.out w]
    #	puts $fid "This service isn't really operational yet"

    #	puts $fid "interspersed is " nonewline
    #	puts $fid $interspersed
    #	puts $fid " server is " nonewline
    #	puts $fid $server
    #	puts $fid " port is " nonewline
    #	puts $fid $port
    #	close $fid

    if { $interspersed } {
	setfield output TYPE application
	setfield output SUBTYPE DIS
	setfield output FILE $src.out
	setfield output DESCRIPTION "DIS results"
	} else {
	setfield part1 TYPE application
	setfield part1 SUBTYPE DIS
	setfield part1 FILE $src.out
	setfield part1 DESCRIPTION "DIS results"

	setfield part2 FILE $src
	setfield part2 DESCRIPTION "original input"

	setfield output TYPE multipart
    	setfield output SUBTYPE mixed
    	setfield output PARTS [list $part1 $part2]
	}

    return [mailout [turnaround $envelope] $output]
}
