/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1992 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type: program/C; charset=US-ASCII
Program:      mmsencode.c (MIME header encoder/decoder driver)
Author:       Yutaka Sato <ysato@etl.go.jp>
Description:
	RFC1522(1342) encoder/decoder for multibyte ISO-2022 charsets

History:
        920515	extracted from mmsclient.c
	921116	separated from mimehead.c
///////////////////////////////////////////////////////////////////////*/

#include <stdio.h>
#include "str_stdio.h"
FILE *str_fopen();

/*//////////////////////////////////////////////////////////////////////*/
MMS_E_head_ENCODER(ac,av,in,out)
	FILE *in,*out;
{
/* test
	char ins[100000],outs[100000];
	int size;

	size = fread(ins,1,sizeof(ins),in);
	ins[size] = 0;
	MIME_strHeaderEncode(ins,outs,sizeof(outs));
	printf("%s\n",outs);
*/
	MIME_headerEncode(in,out);
}
MMS_E_head_DECODER(ac,av,in,out)
	FILE *in,*out;
{
/* test
	char ins[100000],outs[100000];
	int size;

	size = fread(ins,1,sizeof(ins),in);
	ins[size] = 0;
	MIME_strHeaderDecode(ins,outs,sizeof(outs));
	printf("%s\n",outs);
*/
	MIME_headerDecode(in,out,1);
}
MMS_E_decodeBASE16(ac,av,in,out)
	FILE *in,*out;
{
	MMS_decodeBASE16(in,out);
}
MMS_E_encodeBASE16(ac,av,in,out)
	FILE *in,*out;
{
	MMS_encodeBASE16(in,out);
}
int (*MMS_E_HEAD_ENCODER)() = MMS_E_head_ENCODER;
int (*MMS_E_HEAD_DECODER)() = MMS_E_head_DECODER;

int (*MMS_E_DECODEBASE16)() = MMS_E_decodeBASE16;
int (*MMS_E_ENCODEBASE16)() = MMS_E_encodeBASE16;

/*//////////////////////////////////////////////////////////////////////*/
MMS_encodeBASE16(ifp,ofp)
	register FILE *ifp,*ofp;
{	char ibuf[32],obuf[64+2];
	register char *op;
	register int bytes,rc,ci,ch;

	bytes = 0;
	while( 0 < (rc = fread(ibuf,1,sizeof(ibuf),ifp)) ){
		op = obuf;
		for( ci = 0; ci < rc; ci++ ){
			ch = ibuf[ci];
			*op++ = 'A' + (0xF & (ch>>4));
			*op++ = 'A' + (0xF &  ch    );
			bytes++;
		}
		*op++ = '\n';
		fwrite(obuf,rc*2+1,1,ofp);
	}
	fwrite(".\n",2,1,ofp);
	return bytes;
}

MMS_decodeBASE16(ifp,ofp)
	register FILE *ifp,*ofp;
{	char ibuf[64+2],obuf[32];
	register char *op;
	register int bytes,ci,c1,c2;

	bytes = 0;
	while( fgets(ibuf,sizeof(ibuf),ifp) != NULL ){
		if( ibuf[0] == '.' && ibuf[1] == '\n' )
			break;
		op = obuf;
		for( ci = 0; c1 = ibuf[ci]; ci += 2 ){
			if( c1 < 'A' || 'Z' < c1 )
				break;
			c1 -= 'A';
			c2 = ibuf[ci+1] - 'A';
			*op++ = c1 << 4 | c2;
			bytes++;
		}
		fwrite(obuf,ci/2,1,ofp);
	}
	fflush(ofp);
	return bytes;
}

/*//////////////////////////////////////////////////////////////////////*/

MIME_Decode(in,out,encode)
	FILE *in,*out;
	char *encode;
{
	if( strcasecmp(encode,"base64") == 0 )
		from64(in,out,NULL,0);
	else
	if( strcasecmp(encode,"quoted-printable") == 0 )
		fromqp(in,out,NULL,0);
	else{
		fprintf(out,"unknown encoding: %s\n",encode);
	}
	fflush(out);
}

/*//////////////////////////////////////////////////////////////////////*/

#include <ctype.h>

MMS_touppers(str) char *str; {
	char *cp;

	for( cp = str; *cp; cp++ )
		if( islower(*cp) )
			*cp = toupper(*cp);
}
MMS_tolowers(str) char *str; {
	char *cp;

	for( cp = str; *cp; cp++ )
		if( isupper(*cp) )
			*cp = tolower(*cp);
}
