/* demoexp.c  1994 may 19  [gh]
+-----------------------------------------------------------------------------
| Abstract:
|    Demonstrator of exporting messages using the mimelite library.
|
| History:
|    2.0 94 may 19 [gh] Release of version 2.0
|    1.1 94 feb 01 [gh] Improved documentation and MIME support.
|    1.0 94 jan 03 [gh] Wrote first version.
|
| Authorship:
|    Copyright (c) 1994 Gisle Hannemyr.
|    Permission is granted to hack, make and distribute copies of this program
|    as long as this copyright notice is not removed.
|    Flames, bug reports, comments and improvements to:
|       snail: Gisle Hannemyr, Brageveien 3A, 0452 Oslo, Norway
|       email: gisle@oslonett.no, gisle@ifi.uio.no
|
| Design:
|    Use octals rather than explicit presentation of any 8 bit data to make
|    it simple to port source between MSDOS and Unix.
+---------------------------------------------------------------------------*/

#define MAIN

#include <stdio.h>
#include <string.h>
#include "mimelite.h"

/*---( samples )------------------------------------------------------------*/

unsigned char  Jumbo[10000];
unsigned char *JPtr;

static unsigned char *datamsg = (unsigned char *)"\
\311\315\315\315\315\315\315\273\012\
\272\102\111\116\101\122\131\272\012\
\314\315\315\315\315\315\315\271\012\
\272\376\104\101\124\101\376\272\012\
\310\315\315\315\315\315\315\274";

static unsigned char *usascii = (unsigned char *)"\
From: turing@van.de (Dieter Turing)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from Nurnberg\n\
\n\
This body contains an equals-sign (=). It also mentions a town named Nurnberg.\n\
--\n\
Dieter Turing           \\ Gate-POP Nurnberg | EMail: turing@van.de\n\
Schleiermacherstrasse 13 \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 Nurnberg (Germany)  \\ Consulting+Networking+Programming+etc'ing.\n";


unsigned char *isol1_8 = (unsigned char *)"\
From: turing@van.de (Dieter Turing)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from N\374rnberg\n\
\n\
123456789012345678901234567890123456789012345678901234567890123456789012345\n\
This line is contains trailing spaces to make it 70 characters long   \n\
The next line consists of 79 =-signs.\n\
================================================================================\n\
Dieter T\374ring           \\ Gate-POP N\374rnberg | EMail: turing@van.de\n\
Schleiermacherstra\337e 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 N\374rnberg (Germany)  \\ Consulting+Networking+Programming+etc'ing.\n";

static unsigned char *cp437 = (unsigned char *)"\
From: turing@van.de (Dieter T\201ring)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from N\201rnberg\n\
\n\
This body contains an equals-sign (=). It also mentions a town named N\201rnberg.\n\
--\n\
\311\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\
\315\315\315\315\315\315\315\315\315\321\315\315\315\315\315\315\315\315\315\
\315\315\315\315\315\315\315\315\315\315\315\321\315\315\315\315\315\315\315\
\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\273\n\
\272 Dieter T\201ring           \263 Gate-POP N\201rnberg  \263 EMail: turing@van.de \272\n\
\272 Schleiermacherstra\341e 13 \263 Unix+Linux+Mac     \263 Phone: +49 911 46323 \272\n\
\272 90491 N\201rnberg, Germany \263 Consulting+hacking \263 Fax:   +49 911 64739 \272\n\
\310\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\
\315\315\315\315\315\315\315\315\315\317\315\315\315\315\315\315\315\315\315\
\315\315\315\315\315\315\315\315\315\315\315\317\315\315\315\315\315\315\315\
\315\315\315\315\315\315\315\315\315\315\315\315\315\315\315\274\n";

static unsigned char *cp850 = (unsigned char *)"\
From: turing@van.de (Dieter T\201ring)\r\n\
Newsgroups: news.software.nntp\r\n\
Subject: A message from N\201rnberg\r\n\
\r\n\
This body contains an equals-sign (=). It also mentions a town named N\201rnberg.\r\n\
--    \r\n\
\332\304\304\304\304\304\304\304\304\304\304\304\304\304\304\304\304\
\304\304\304\304\304\304\304\304\304\302\304\304\304\304\304\304\304\304\304\
\304\304\304\304\304\304\304\304\304\304\304\302\304\304\304\304\304\304\304\
\304\304\304\304\304\304\304\304\304\304\304\304\304\304\304\277\r\n\
\263 Dieter T\201ring           \263 Gate-POP N\201rnberg  \263 EMail: turing@van.de \263\r\n\
\263 Schleiermacherstra\341e 13 \263 Unix+Linux+Mac     \263 Phone: +49 911 46323 \263\r\n\
\263 90491 N\201rnberg, Germany \263 Consulting+hacking \263 Fax:   +49 911 64739 \263\r\n\
\300\304\304\304\304\304\304\304\304\304\304\304\304\304\304\304\304\
\304\304\304\304\304\304\304\304\304\301\304\304\304\304\304\304\304\304\304\
\304\304\304\304\304\304\304\304\304\304\304\301\304\304\304\304\304\304\304\
\304\304\304\304\304\304\304\304\304\304\304\304\304\304\304\331\r\n";

static unsigned char *apple = (unsigned char *)"\
From: turing@van.de (Dieter T\237ring)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from N\237rnberg\n\
\n\
This body contains an equals-sign (=). It also mentions a town named N\237rnberg.\n\
--\n\
Dieter T\237ring           \\ Gate-POP N\237rnberg | EMail: turing@van.de\n\
Schleiermacherstra\247e 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 N\237rnberg (Germany)  \\ Consulting+Networking+Programming+etc'ing.\n";


/*---( demonstrator )-------------------------------------------------------*/

/*
| Abs: Feed mimelite content of message, one byte at the time.
| Des: This is a function which you need to write so that mimelite can call
|      it (a pointer to it is passed as the 4th parameter of ml_mimemessage).
|      It is pretty simple in this demonstrator, because we rely on a global
|      buffer to hold the message.  In your application, memory might be a
|      real concern, so you may want to handle this different (e.g. read the
|      message from a file).
*/
static int mygetc(void)
{
    return(*JPtr++);
} /* mygetc */


/*
| Abs: This is the meat of the demonstrator.  It shows who you should use
|      the mimelite library to export messages containing European
|      charcters.
| Imp: The demonstrator will take the message and fold from the character
|      set indicated by cset and into ISO Latin 1 (the native character set
|      of Usenet).  It will then show two alternative ways of outputting
|      the message.
| Par: ipcs = the original character set used to create the message.  This
|            is usually the native character set of the environment the
|            software is running in.
|      bcte = content-transfer-encoding to use for body.
|             For example: CE_UNCODED for news, CE_QUOTEDP for mail.
|      bhbt = one if message body contains characters with highbit set
|      head = zero if message w/o head.
*/
static void demonstrator(int ipcs, int bcte, int bhbt, int head)
{
    int headcte, bodycst;

    /*
    | Set up translation parameters for folding.  The input character set
    | should be the native character set for the computer the program is
    | running on (e.g. the code page the machine is set up to use).  The
    | sample texts included with this demonstrator simulates several different
    | environments, so we parameterize icps here.  The only value for oset
    | that makes sense when exporting messages to Usenet is CS_ISOL1. It is
    | OK to specify CS_ISOL1 even if the message exported uses only US ASCII
    | (because US ASCII is a pure subset of ISO latin 1).  
    */
    if (!ml_foldinit(ipcs, CS_ISOL1)) {
	fputs("*** unknown charset\n", stderr);
	return;
    } /* if */

    /*
    | Determine what encoding to use for message header.  We use the value of
    | of bcte to tell us whether we can rely on 8 bit transport or not.
    */
    if (head) headcte = (CE_UNCODED == bcte) ? CE_UNCODED : CE_STRIP_7;
    else      headcte = CE_NO_HEAD;

    /*
    | Determine what character set we need to use for message body.
    */
    if (ipcs != CS_UNKWN) bodycst = bhbt ? CS_ISOL1 : CS_IR002;

    /*
    | And we don't want use quoted-printable when there is no need to, so
    | let's change bcte to no encoding if all we export is 7 bit ASCII.
    */
    if ((bodycst == CS_IR002) && (bcte == CE_QUOTEDP)) bcte = CE_UNCODED;

    /*
    | Finally, let's export the message!
    */
    ml_mimemessage(headcte, bcte, bodycst, mygetc, stdout);

} /* demonstrator */


/*---( main )---------------------------------------------------------------*/

int main(/* int  argc, char *argv[] */)
{
    char buff[80];
    char *ss;
    int ii, cset, cte, hbt, head;

    fputs("\n\n\
This demonstrator provides several sample messages for testing.  These\n\
represent the original message to be mailed or posted, as input by the\n\
user.\n", stdout);
    for (;;) {
	fputs("\n\
Please select one off these sample messages:\n\
    1) data       (8 bit binary data w/o header)\n\
    2) ISO-IR-02  (7 bit US-ASCII)\n\
    3) ISO-8859/1 (8 bit ISO Latin 1)\n\
    4) IBM CP 437 (8 bit IBM PC USA)\n\
    5) IBM CP 850 (8 bit IBM PC multinational)\n\
    6) Macintosh  (8 bit Apple MacIntosh)\n\
    0) (Exit)\n\
Select one (0-6) : ", stdout);
	fflush(stdout);
	fgets(buff, 10, stdin);
	sscanf(buff, "%d", &ii);
	if ((ii <= 0) || (ii > 6)) break;

	switch (ii) {
	  case 1:  ss = datamsg; cset = CS_UNKWN; hbt = 1; head = 0; break;
	  case 2:  ss = usascii; cset = CS_IR002; hbt = 0; head = 1; break;
	  case 3:  ss = isol1_8; cset = CS_ISOL1; hbt = 1; head = 1; break;
	  case 4:  ss = cp437;   cset = CS_CP437; hbt = 1; head = 1; break;
	  case 5:  ss = cp850;   cset = CS_CP850; hbt = 1; head = 1; break;
	  case 6:  ss = apple;   cset = CS_APPLE; hbt = 1; head = 1; break;
	  default: fputs("*** Unknown demo.\n", stderr); return(1);
	} /* switch */

	fputs("\n\
NOTE: Unless your native character set is ISO Latin 1, the \"Uncoded\"\n\
      content-transfer-encoding may not look correct on your screen.\n\
Please select contents-transfer-encoding :\n\
    1) Original message (Use for debugging)\n\
    2) Uncoded          (Use this for news)\n\
    3) Quoted-printable (Use this for mail)\n\
    4) Base 64          (Use this for data)\n\
    0) (Exit)\n\
Select one (0-4) : ", stdout);
	fflush(stdout);
	fgets(buff, 10, stdin);
	sscanf(buff, "%d", &ii);
	if ((ii <= 0) || (ii > 4)) break;
	cte = ii - 2;

	/* Copy to a global message buffer to keep demonstrator simple. */
	strcpy(Jumbo, ss);
	JPtr = Jumbo;
	fputs("============================================================================\n",  stdout);
	if (cte >= 0) demonstrator(cset, cte, hbt, head); /* show mimed     */
	else	      fputs(Jumbo, stdout);		  /* show original  */
	fputs("============================================================================\n",  stdout);

    } /* forever */

    return(0);


} /* main */

/* EOF */
