.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH REFILE %manext1% MH.6.8 [%nmhversion%]
.SH NAME
refile \- file message in other folders
.SH SYNOPSIS
.in +.5i
.ti -.5i
refile 
\%[msgs] 
\%[\-draft]
\%[\-link] \%[\-nolink]
.br
\%[\-preserve] \%[\-nopreserve]
\%[\-unlink] \%[\-nounlink]
.br
\%[\-src\ +folder] 
\%[\-file\ file]
\%[\-rmmproc program]
.br
\%[\-normmproc]
+folder1 ...
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIRefile\fR moves (\fImv\fR\0(1)) or links (\fIln\fR\0(1)) messages
from a source folder into one or more destination folders.

If you think of a message as a sheet of paper, this operation is not
unlike filing the sheet of paper (or copies) in file cabinet folders.
When a message is filed, it is linked into the destination folder(s)
if possible, and is copied otherwise.  As long as the destination
folders are all on the same file system, multiple filing causes little
storage overhead.  This facility provides a good way to cross\-file or
multiply\-index messages.  For example, if a message is received from
Jones about the ARPA Map Project, the command

     refile\0cur\0+jones\0+Map

would allow the message to be found in either of the two folders `jones'
or `Map'.

You may specify the source folder using `\-src\ +folder'.  If this is
not given, the current folder is used by default.  If no message is
specified, then `cur' is used by default.

The option `\-file\ file' directs \fIrefile\fR to use the specified file
as the source message to be filed, rather than a message from a folder.
Note that the file should be a validly formatted message, just like
any other \fInmh\fR message.  It should \fBNOT\fR be in mail drop format
(to convert a file in mail drop format to a folder of \fInmh\fR messages,
see \fIinc\fR\0(1)).

If a destination folder doesn't exist, \fIrefile\fR will ask if you want
to create it.  A negative response will abort the file operation.  If the
standard input for \fIrefile\fR is \fInot\fR a tty, then \fIrefile\fR
will not ask any questions and will proceed as if the user answered
\*(lqyes\*(rq to all questions.

The option `\-link' preserves the source folder copy of the message (i.e.,
it does a \fIln\fR(1) rather than a \fImv\fR(1)), whereas, `\-nolink'
(the default) deletes the filed messages from the source folder.

Normally when a message is refiled, for each destination folder it
is assigned the number which is one above the current highest message
number in that folder.  Use of the `\-preserve' switch will override
this message renaming, and try to preserve the number of the message.
If a conflict for a particular folder occurs when using the `\-preserve'
switch, then \fIrefile\fR will use the next available message number
which is above the message number you wish to preserve.

If `\-link' is not specified (or `\-nolink' is specified), the filed
messages will be removed from the source folder.  The default is to
remove these messages by renaming them with a site-dependent prefix
(usually a comma).  Such files will then need to be removed in some
manner after a certain amount of time.  Many sites arrange for
\fIcron\fR\0(8) to remove these files once a day, so check with your
system administrator.

Alternately, if you wish for \fIrefile\fR to really remove the files
representing these messages from the source folder, you can use the
`-unlink' switch (not to be confused with the -link switch).  But
messages removed by this method cannot be later recovered.

.ne 4
If you prefer a more sophisticated method of `removing' the messages
from the source folder, you can define the \fIrmmproc\fR profile
component.  For example, you can add a profile component such as

	rmmproc:	/home/coleman/bin/rmm_msgs

then \fIrefile\fR will instead call the named program or script to
handle the message files.

The user may specify `\-rmmproc program' on the command line to
override this profile specification.  The `-normmproc' option forces
the message files to be deleted by renaming or unlinking them as
described above.

The `\-draft' switch tells \fIrefile\fR to file the <mh\-dir>/draft.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^Folder\-Protect:~^To set mode when creating a new folder
.Ps
^rmmproc:~^Program to delete the message
.Sa
folder(1), rmf(1), rmm(1)
.De
`\-src\ +folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-nolink'
.Ds
`\-nounlink'
.Ds
`\-nopreserve'
.Co
If `\-src\ +folder' is given, it will become the current folder.
If neither `\-link' nor `all' is specified, the current message in the
source folder will be set to the last message specified; otherwise, the
current message won't be changed.

If the Previous\-Sequence profile entry is set, in addition to defining
the named sequences from the source folder, \fIrefile\fR will also define
those sequences for the destination folders.  See \fImh\-sequence\fR\0(5)
for information concerning the previous sequence.
.Bu
Since \fIrefile\fR uses your \fIrmmproc\fP to delete the message,
the \fIrmmproc\fP must \fBNOT\fP call \fIrefile\fP without specifying
`\-normmproc', or you will create an infinite loop.
.En
