
/*
 * closefds.c - close-up fd's
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../config.h"
#include "../h/mh.h"

#ifdef HAVE_LIMITS_H
# include <stdio.h>
# include <limits.h>
#endif

/* get maximum number of open file descriptors */
#ifndef OPEN_MAX
# ifdef NOFILE
#  define OPEN_MAX NOFILE
# else
   /* so we will just pick something */
#  define OPEN_MAX 20
# endif
#endif

void
closefds(int i)
{
    int nbits = OPEN_MAX;

    for (; i < nbits; i++)
#ifdef	OVERHEAD
	if (i != fd_def && i != fd_ctx)
#endif	/* OVERHEAD */
	    close (i);
}
