
/*
 * m_maildir.c -- get the path for the mail directory
 *
 * $Id$
 */

#include "../h/mh.h"

#define	CWD	"./"
#define	NCWD	(sizeof CWD - 1)
#define	DOT	"."
#define	DOTDOT	".."
#define	PWD	"../"
#define	NPWD	(sizeof PWD - 1)

static char mailfold[BUFSIZ];

/*
 * static prototypes
 */
static char *exmaildir (char *);


char *
m_maildir (char *folder)
{
    register char *cp, *ep;

    if ((cp = exmaildir (folder))
	    && (ep = cp + strlen (cp) - 1) > cp
	    && *ep == '/')
	*ep = 0;

    return cp;
}


char *
m_mailpath (char *folder)
{
    register char *cp;
    char maildir[BUFSIZ];

    if (*folder == '/'
	    || strncmp (folder, CWD, NCWD) == 0
	    || strcmp (folder, DOT) == 0
	    || strcmp (folder, DOTDOT) == 0
	    || strncmp (folder, PWD, NPWD) == 0)
	cp = path (folder, TFOLDER);
    else {
	strcpy (maildir, mailfold);/* preserve... */
	cp = getcpy (m_maildir (folder));
	strcpy (mailfold, maildir);
    }

    return cp;
}


static char *
exmaildir (char *folder)
{
    register char *cp, *pp;

    /* use current folder if none is specified */
    if (folder == NULL)
	folder = m_getfolder();

    if (*folder == '/'
	    || strncmp (folder, CWD, NCWD) == 0
	    || strcmp (folder, DOT) == 0
	    || strcmp (folder, DOTDOT) == 0
	    || strncmp (folder, PWD, NPWD) == 0) {
	strcpy (mailfold, folder);
	return mailfold;
    }

    cp = mailfold;
    if ((pp = m_find ("path")) != NULL && *pp) {
	if (*pp != '/') {
	    sprintf (cp, "%s/", mypath);
	    cp += strlen (cp);
	}
	cp = copy (pp, cp);
    }
    else
	cp = copy (path ("./", TFOLDER), cp);
    if (cp[-1] != '/')
	*cp++ = '/';
    strcpy (cp, folder);

    return mailfold;
}
