.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MH-TAILOR %manext5% MH.6.8 [%nmhversion%]
.SH NAME
mh-tailor, mts.conf \- mail transport customization for nmh message handler

.SH SYNOPSIS
.in +.5i
.ti -.5i
\fI%etcdir%/mts.conf\fP
.in -.5i
.SH DESCRIPTION
The file %etcdir%/mts.conf defines run-time options for those \fInmh\fR
programs which interact (in some form) with the message transport system.
At present, these (user) programs are: \fIap\fR, \fIconflict\fR,
\fIinc\fR, \fImsgchk\fR, \fImsh\fR, \fIpost\fR, \fIrcvdist\fR, and
\fIrcvpack\fR.

Each option should be given on a single line.  Blank lines and lines
which begin with `#' are ignored.  The options available along with
default values and a description of their meanings are listed below:

.in +.5i
.ti -.5i
localname:
.br
The host name \fInmh\fR considers local.  If not set, depending on the
version of UNIX you're running, \fInmh\fR will query the system for this
value (e.g., <whoami.h>, gethostname, etc.).  POP client hosts should
set this value to the name of the POP service host.

.ti -.5i
localdomain:
.br
If this is set, a `.' followed by this string will be appended to your
host name.  This might be useful for sites where the host name returned
by the system (e.g., <whoami.h>, gethostname, etc.), is not a \*(lqfully
qualified domain name\*(rq (i.e., does not contain a `.').

.ti -.5i
clientname:
.br
This option specifies the host name that \fInmh\fP will give in the
SMTP \fBHELO\fP (and \fBEHLO\fP) command, when posting mail.  If not
set, the default is to use the host name that \fInmh\fR considers local
(see \*(lqlocalname\*(rq above).  If this option is set, but empty, no
\fBHELO\fP command will be given.

.sp
Although the \fBHELO\fP command is required by RFC 821, many SMTP servers
do not require it.  Early versions of SendMail will fail if the host name
given in the \fBHELO\fP command is the local host.  Later versions of
SendMail will complain if you omit the \fBHELO\fP command.  If you run
SendMail, find out what your system expects and set this field if needed.

.ti -.5i
systemname:
.br
The name of the local host in the \fIUUCP\fR \*(lqdomain\*(rq.  If not
set, depending on the version of UNIX you're running, \fInmh\fR will
query the system for this value.  This has no equivalent in the \fInmh\fR
configuration file.

.ti -.5i
mmdfldir: %mailspool%
.br
The directory where maildrops are kept.  If this is empty, the user's
home directory is used.  This overrides the \*(lqmail\*(rq field in the
\fInmh\fR configuration file.

.ti -.5i
mmdflfil: 
.br
The name of the maildrop file in the directory where maildrops are kept.
If this is empty, the user's login name is used.  This overrides the
\*(lqmail\*(rq field in the \fInmh\fR configuration file.

.ti -.5i
mmdelim1: \\001\\001\\001\\001\\n
.br
The beginning-of-message delimiter for maildrops.

.ti -.5i
mmdelim2: \\001\\001\\001\\001\\n
.br
The end-of-message delimiter for maildrops.

.ti -.5i
mmailid: 0
.br
If non-zero, then support for MMailids in \fB/etc/passwd\fR is enabled.
Basically, the pw_gecos field in the password file is of the form

.ti +.5i
My Full Name <mailid>

The \fInmh\fR internal routines that deal with user and full names will
return \*(lqmailid\*(rq and \*(lqMy Full Name\*(rq respectively.

.ti -.5i
lockstyle: 0
.br
The locking discipline to perform.  A value of \*(lq0\*(rq means to
use kernel-level locking if available.  (See below for more details.)
On systems compiled without kernel-level locking, standard \fIBellMail\fR
locking is used.  A value of \*(lq1\*(rq means to use \fIBellMail\fR
locking always (the name of the lock is based on the file name).  A value
of \*(lq2\*(rq means to use \fIMMDF\fR locking always (the name of the
lock is based on device/inode pairs).

.ti -.5i
lockldir:
.br
The name of the directory for making locks.  If your system isn't
configured to use kernel-level locking, then this directory is used when
creating locks.  If the value is empty, then the directory of the file
to be locked is used.

.ti -.5i
maildelivery: %libdir%/maildelivery
.br
The name of the system-wide default \fI\&.maildelivery\fR file.
See \fIslocal\fR\0(1) for the details.

.ti -.5i
everyone: 200
.br
The highest user-id which should NOT receive mail addressed to
\*(lqeveryone\*(rq.

.ti -.5i
noshell: 
.br
If set, then each user-id greater than \*(lqeveryone\*(rq that has a
login shell equivalent to the given value (e.g., \*(lq/bin/csh\*(rq)
indicates that mail for \*(lqeveryone\*(rq should not be sent to them.
This is useful for handling admin, dummy, and guest logins.
.\" @BEGIN: MF
.in -.5i
.Uh "Mail Filtering"
These options are only available if you compiled \fInmh\fP with
\*(lqoptions\ MF\*(rq.

.in +.5i
.ti -.5i
uucpchan: name of \fIUUCP\fR channel
.br
Usually \*(lqUUCP\*(rq.
This has no equivalent in the \fInmh\fR configuration file.

.ti -.5i
uucpldir: /usr/spool/mail
.br
The name of the directory where \fIUUCP\fR maildrops are kept.  This has
no equivalent in the \fInmh\fR configuration file.

.ti -.5i
uucplfil:
.br
The name of the maildrop file in the directory where \fIUUCP\fR maildrops
are kept.  If this is empty, the user's login name is used.  This has
no equivalent in the \fInmh\fR configuration file.

.ti -.5i
umincproc: %libdir%/uminc
.br
The path to the program that filters \fIUUCP\fR\^-style maildrops to
\fIMMDF\fR\^-style maildrops.
.\" @END: MF
.\" @BEGIN: MHMTS
.in -.5i
.Uh "Stand-Alone Delivery"
These options are only available if you compiled \fInmh\fP to use
stand-alone delivery (i.e., \*(lqmts:\ mh\*(rq).

.in +.5i
.ti -.5i
mailqdir: /usr/spool/netmail
.br
The directory where network mail is queued.

.ti -.5i
tmailqdir: /usr/tmp
.br
The directory where network mail queue files are built.

.ti -.5i
syscpy: 1
.br
If ON, unauthorized mail is copied to the overseer.

.ti -.5i
overseer: root
.br
The user that receives reports of unauthorized mail.

.ti -.5i
mailer: root
.br
The user acting for the mail system.

.ti -.5i
fromtmp: /tmp/rml.f.XXXXXX
.br
The \fImktemp\fR template for storing from lines.

.ti -.5i
msgtmp: /tmp/rml.m.XXXXXX
.br
The \fImktemp\fR template for storing the rest of the message.

.ti -.5i
errtmp: /tmp/rml.e.XXXXXX
.br
The \fImktemp\fR template for storing error messages from other mailers.

.ti -.5i
tmpmode: 0600
.br
The octal mode which temporary files are set to.

.ti -.5i
okhosts: %etcdir%/Rmail.OKHosts
.br
A file containing a list of hosts that can send ARPAnet mail.

.ti -.5i
okdests: %etcdir%/RMail.OKDests
.br
A file containing a list of hosts that can always receive mail.
.\" @END: MHMTS
.\" @BEGIN: SMTP
.in -.5i
.Uh "The `/smtp' MTS Suffix"
These options are only available if you compiled \fInmh\fP with the
\*(lq/smtp\*(rq suffix to your \*(lqmts:\*(rq configuration.

.in +.5i
.ti -.5i
hostable: %etcdir%/hosts
.br
The exceptions file for /etc/hosts used by \fIpost\fR to try to find
official names.  The format of this file is quite simple:

.in +.5i
1. Comments are surrounded by sharp (`#') and newline.
.br
2. Words are surrounded by white space.
.br
3. The first word on the line is the official name of a host.
.br
4. All words following the official names are aliases for that host.
.in -.5i

.ti -.5i
servers: localhost \\01localnet
.br
A lists of hosts and networks which to look for SMTP servers when
posting local mail.  It turns out this is a major win for hosts which
don't run an message transport system.  The value of \*(lqservers\*(rq
should be one or more items.  Each item is the name of either a host
or a net (in the latter case, precede the name of the net by a \\01).
This list is searched when looking for a smtp server to post mail.
If a host is present, the SMTP port on that host is tried.  If a net
is present, the SMTP port on each host in that net is tried.  Note that
if you are running with the BIND code, then any networks specified are
ignored (sorry, the interface went away under BIND).
.\" @END: SMTP
.\" @BEGIN: SENDMTS
.in -.5i
.Uh "SendMail"
This option is only available if you compiled \fInmh\fP to use
\fISendMail\fP as your delivery agent (i.e., \*(lqmts:\ sendmail\*(rq).

.in +.5i
.ti -.5i
sendmail: %sendmailpath%
.br
The pathname to the \fIsendmail\fR program.
.\" @END: SENDMTS
.\" @BEGIN: POP
.in -.5i
.Uh "Post Office Protocol"
This option is only available if you have compiled \fInmh\fP with POP
support enabled (i.e., \*(lq--enable-nmh-pop\*(rq).

.in +.5i
.ti -.5i
pophost:
.br
The name of the default POP service host.  If this is not set, then
\fInmh\fR looks in the standard maildrop areas for waiting mail, otherwise
the named POP service host is consulted.
.\" @END: POP
.\" @BEGIN: BBSERVER
.in -.5i
.Uh "BBoards Delivery"
This option is only available if you compiled \fInmh\fP with
\*(lqbbdelivery:\ on\*(rq.

.in +.5i
.ti -.5i
bbdomain:
.br
The local BBoards domain (a UCI hack).
.\" @END: BBSERVER
.\" @BEGIN: BPOP
.in -.5i
.Uh "BBoards & The POP"
These options are only available if you compiled \fInmh\fP with
\*(lqbboards:\ pop\*(rq and \*(lqpop:\ on\*(rq.

.in +.5i
.ti -.5i
popbbhost:
.br
The POP service host which also acts as a BBoard server.  This variable
should be set on the POP BBoards client host.

.ti -.5i
popbbuser:
.br
The guest account on the POP/BB service host.  This should be a different
login ID than either the POP user or the BBoards user.  (The user-id
\*(lqftp\*(rq is highly recommended.)  This variable should be set on
both the POP BBoards client and service hosts.

.ti -.5i
popbblist: %etcdir%/hosts.popbb
.br
A file containing of lists of hosts that are allowed to use the POP
facility to access BBoards using the guest account.  If this file is not
present, then no check is made.  This variable should be set on the POP
BBoards service host.
.\" @END: BPOP
.\" @BEGIN: NNTP
.in -.5i
.if n .ne 8
.Uh "BBoards & The NNTP"
This option is only available if you compiled \fInmh\fP with
\*(lqbboards:\ nntp\*(rq and \*(lqpop:\ on\*(rq.

.in +.5i
.ti -.5i
nntphost:
.br
The host which provides the NNTP service.  This variable should be set
on the NNTP BBoards client host.
.\" @END: NNTP
.in -.5i
.Uh "File Locking"
A few words on locking: \fInmh\fR has a flexible locking system for making
locks on files.  There are two \fBmts.conf\fR variables you should be
aware of \*(lqlockstyle\*(rq and \*(lqlockldir\*(rq.  The first controls
the method of locking, the second says where lock files should be created.

The \*(lqlockstyle\*(rq variable can take on three values: 0, 1, 2.
A value of 0 is useful on systems with kernel-level locking.  If you
are on a \fBBSD42\fP system, \fInmh\fP assumes you have the \fIflock\fR
system call.  On other systems: define \fBFLOCK\fP if you want to use
the \fIflock\fP system call; define \fBLOCKF\fP if you want to use
the \fIlockf\fP system call; or define \fBFCNTL\fP if you want to use
the \fIfcntl\fP system call for kernel-level locking.  If you haven't
configured \fInmh\fP to use kernel-level locking, a locking style of 0
is considered the same as locking style 1.

A value of 1 or 2 specifies that a file should be created whose existence
means \*(lqlocked\*(rq and whose non-existence means \*(lqunlocked\*(rq.
A value of 1 says to construct the lockname by appending \*(lq.lock\*(rq
to the name of the file being locked.  A value of 2 says to construct
the lockname by looking at the device and inode numbers of the file being
locked.  If the \*(lqlockldir\*(rq variable is not specified, lock files
will be created in the directory where the file being locked resides.
Otherwise, lock files will be created in the directory specified by
\*(lqlockldir\*(rq.  Prior to installing \fInmh\fR, you should see how
locking is done at your site, and set the appropriate values.

.Fi
^%etcdir%/mts.conf~^nmh mts configuration file
.Pr
None
.Sa
mh\-gen(8), mh\-mts(8)
.De
As listed above
.Co
None
.En
