
/*
 * push.c -- push a fork into the background
 *
 * $Id$
 */

#include <h/mh.h>
#include <h/signals.h>
#include <signal.h>


void
push(void)
{
    register int i;

    for (i = 0; i < 5; i++) {
	switch (fork ()) {
	    case NOTOK: 
		sleep (5);
		continue;

	    case OK: 
		SIGNAL (SIGHUP, SIG_IGN);
		SIGNAL (SIGINT, SIG_IGN);
		SIGNAL (SIGQUIT, SIG_IGN);
		SIGNAL (SIGTERM, SIG_IGN);
#ifdef SIGTSTP
		SIGNAL (SIGTSTP, SIG_IGN);
		SIGNAL (SIGTTIN, SIG_IGN);
		SIGNAL (SIGTTOU, SIG_IGN);
#endif /* SIGTSTP */
		freopen ("/dev/null", "r", stdin);
		freopen ("/dev/null", "w", stdout);
		break;

	    default: 
		done (0);
	}
	break;
    }
    if (i >= 5)
	advise (NULL, "unable to fork, so can't push...");
}

