
/*
 * seq_setunseen.c -- add/delete all messages which have the UNSEEN
 *                 -- bit set to/from the Unseen-Sequence
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * We scan through the folder and act upon all
 * messages that are marked with the UNSEEN bit.
 *
 * If seen == 1, delete messages from unseen sequence.
 * If seen == 0, add messages to unseen sequence.
 */

void
seq_setunseen (struct msgs *mp, int seen)
{
    int msgnum;
    char **ap, *cp;
    char *dp = NULL;

    /*
     * Get the list of sequences for Unseen-Sequence
     * and split them.
     */
    if ((cp = context_find (usequence)) == NULL
	    || (ap = brkstring (dp = getcpy (cp), " ", "\n")) == NULL
	    || *ap == NULL) {
	if (dp)
	    free (dp);
	return;
    }

    /*
     * Now add/delete each message with the UNSEEN bit
     * set to/from each of these sequences.
     */
    for (; *ap; ap++) {
	if (seen) {
	    /* make sure sequence exists first */
	    if (seq_getnum(mp, *ap) != -1)
		for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
		    if (is_unseen (mp, msgnum))
			seq_delmsg (mp, *ap, msgnum);
	} else {
	    for (msgnum = mp->lowmsg; msgnum <= mp->hghmsg; msgnum++)
		if (is_unseen (mp, msgnum))
		    seq_addmsg (mp, *ap, msgnum, -1, 0);
	}
    }

    if (dp)
	free (dp);
}
