.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH RCVSTORE %manext1% MH.6.8 [%nmhversion%]
.SH NAME
rcvstore \- asynchronously incorporate mail into a folder
.SH SYNOPSIS
.in +.5i
.ti -.5i
%libdir%/rcvstore
\%[+folder]
\%[\-create]
.br
\%[\-nocreate]
\%[\-sequence\ name\ ...]
\%[\-public]
.br
\%[\-nopublic]
\%[\-zero] \%[\-nozero]
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIRcvstore\fR incorporates a message from the standard input into an
\fInmh\fR folder.  This command is typically used in conjunction with
mail filtering programs such as \fIslocal\fR and \fIprocmail\fR, to
filter your mail into different folders.

If `+folder' isn't specified, a folder in the user's \fInmh\fR directory
will be used, either that specified by a non\-empty \*(lqInbox:\*(rq
entry in the user's profile, or the folder named \*(lqinbox\*(rq.  If the
specified (or default) folder doesn't exist, then it will be created if
the `\-create' option is specified, otherwise \fIrcvstore\fP will exit.

When the new message is incorporated into the folder, it is assigned
the next highest number for that folder.

\fIRcvstore\fR will incorporate anything except zero length messages
into the user's nmh folder.

If the user's profile contains a \*(lqMsg\-Protect: nnn\*(rq entry, it
will be used as the protection on the newly created message, otherwise
the \fInmh\fR default of 0644 will be used.  For all subsequent operations
on this message, this initially assigned protection will be preserved.

If the profile entry \*(lqUnseen\-Sequence\*(rq is present and
non\-empty, then \fIrcvstore\fR will add the newly incorporated message
to each sequence named by the profile entry.  This is similar to the
\*(lqPrevious\-Sequence\*(rq profile entry supported by all \fInmh\fR
commands which take `msgs' or `msg' arguments.  By default, \fIrcvstore\fR
will not zero each sequence prior to adding messages.

Furthermore, the incoming messages may be added to user-defined sequences
as they arrive by the use of the `\-sequence' switch.  As with the
commands \fIpick\fP and \fImark\fP, you may also use the switches
`\-zero' and `\-nozero' to specify whether to zero old sequences or not.
Similarly, use of the `\-public' and `\-nopublic switches may be used
to force these sequences to be public or private sequences.

.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Folder\-Protect:~^To set mode when creating a new folder
.Ps
^Inbox:~^To find the default inbox
.Ps
^Msg\-Protect:~^To set mode when creating a new message
.Ps
^Unseen\-Sequence:~^To name sequences denoting unseen messages
.Sa
rcvdist(1), rcvpack(1), rcvtty(1), mh\-sequence(5)
.De
`+folder' defaults to \*(lqInbox\*(rq profile entry
.Ds
`\-create'
.Ds
`\-nozero'
.Co
No context changes will be attempted, with the exception of
sequence manipulation.
.Bu
If you use the \*(lqUnseen\-Sequence\*(rq profile entry, \fIrcvstore\fP
could try to update the context while another \fInmh\fP process
is also trying to do so.  This can cause the context to become
corrupted.  To avoid this, do not use \fIrcvstore\fP if you use the
\*(lqUnseen\-Sequence\*(rq profile entry.
.En
