
/*
 * brkstring.c -- break a string into an array of strings
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * array of substring start addresses
 */
static char *broken[MAXARGS+1];

/*
 * static prototypes
 */
static int brkany (char, char *);


char **
brkstring (char *strg, char *brksep, char *brkterm)
{
    int i;
    char c, *sp;

    /*
     * scan string, replacing separators with zeroes
     */
    sp = strg;

    for (i = 0; i < MAXARGS; i++) {
				/* and entering start addrs in "broken" */
	while (brkany (c = *sp, brksep))
	    *sp++ = 0;

	if (!c || brkany (c, brkterm)) {
	    *sp = 0;
	    broken[i] = 0;
	    return broken;	/* terminator found, finish up */
	}

	broken[i] = sp;	/* set next start addr */
	while ((c = *++sp) && !brkany (c, brksep) && !brkany (c, brkterm))
		continue;
    }
    broken[MAXARGS] = 0;	/* reached limit of MAXARGS substrings */

    return broken;
}


/*
 * returns 1 if chr in strg, 0 otherwise
 */
static int
brkany (char chr, char *strg)
{
    char *sp;

    if (strg)
	for (sp = strg; *sp; sp++)
	    if (chr == *sp)
		return 1;
    return 0;
}
