# pr_isearch.pl -- index search
# SCCS Status     : @(#)@ pr_isearch.pl	3.3
# Author          : Johan Vromans
# Created On      : Thu Jun  4 22:13:56 1992
# Last Modified By: Johan Vromans
# Last Modified On: Mon Aug 17 17:38:56 1992
# Update Count    : 8
# Status          : OK

sub indexsearch {

    local ($ixfile, $lib, $request) = @_;

    # Locate an archive item $request in library $libdir by
    # inspecting the associated index file.
    # Eligible items are in the format XXX.EXT, or XXX-VVV.EXT, where
    # VVV is assumed to be a version indicator (and must start with a digit).
    #
    # See "sub search" for a description of the return values.

    return () unless -s $ixfile;

    # Lookup a request in index.

    local ($tryfile, $subdir, $pat);
    local (@retval);		# return value

    # Normalize the request.
    ($subdir, $tryfile) = &fnsplit ($request);
    $pat = $subdir ne "" ? "$subdir/$tryfile" : $tryfile;
    $pat =~ s/(\W)/\\\1/g;

    print STDOUT ("Lookup $tryfile ($pat) in $ixfile...\n") if $opt_debug;

    # GNU locate 3.6 (or a customized version of GNU locate 3.5)
    # will return info.
    $ENV{"LOCATE_DB"} = $ixfile;	# find 3.6 or 3.5cust
    $ENV{"LOCATE_PATH"} = $ixfile;	# find 3.7
    open (INDEX, "$ixlookup '$tryfile' |");

    local ($base, $version, $extension);
    local ($date, $size, $file);

    while ( <INDEX> ) {
	chop;

	# Returned info: path?size in K?mdate, e.g.
	# zoo-2.01/zoo.TZ?172?910807

	($file, $size, $date) = /^(.+)\?(\d+)\?(\d+)$/;

	if ( defined $file ) {

	    (($base, $version, $extension) =
	     $file =~ m:^($pat|.+/$pat)(-\d[^/]*|)$extpat$:)
		|| (($base, $version, $extension) =
		    $file =~ m:^($pat|.+/$pat)(-\d[^/]*|)$:);

	    # Nope.
	    next unless defined $base;
	    $file = $base;

	    # Adjust XX -YYY.tar .Z -> XX -YYY .tar.Z 
	    $extension = "" unless defined $extension;
	    ($version, $extension) = ($`, $&.$extension) 
		if $extension eq ".Z" && $version =~ /\.(sh|t)ar$/;

	    $date =~ s|^(..)(..)(..)|1900+$1."/$2/$3"|e;

	    ($subdir, $base) = &fnsplit ($file);
	    $subdir .= "/" if $subdir ne "";
	    $lib .= "/" unless $lib =~ m|/$|;

	    push (@retval,
		  &zp ($base.$version.$extension, $size."K", "T".$date,
		       $lib, $subdir));
	    next;
	}

    }

    close (INDEX);
    print STDOUT ("Found ", 0+@retval, " entries\n") if $opt_debug;
    @retval;
}

1;
