/* ************************************************************ *
 *								*
 *		CMD-ARCHIE.C					*
 *								*
 *	A part of main piece of mail (and other) servers.	*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <sys/resource.h>
#include <varargs.h>
#include "proto.h"	/* Prototypes.. */
#include "config.h"

extern int ftp_uid;
extern int ftp_gid;
extern char ftp_home[MAXPATHLEN];
extern int ftp_home_len;

static char *MsrvTempName = "/tmp/msrv.XXXXXX";

/* ****************************************************************
 *
 * do_archie() -- mail out results of an archie query. Use prospero interface.
 *
 * **************************************************************** */

#if DOES_ARCHIE
int archie_pid = 0;

void archie_alarm(n)
int n;
{
	if (archie_pid > 1)
		kill(archie_pid,SIGTERM);
	alarm(5*60);	/* Re-alarm in 5 minutes.. */
}
#endif

int
do_archie(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
#if DOES_ARCHIE
	FILE *tmpfil, *lspipe;
	int lines = 0;
	char tmpstr[MAXPATHLEN];
	char tempname[MAXPATHLEN];

	archie_pid = 0;
	signal(SIGALRM,archie_alarm);
	alarm(30*60); /* 30 minutes */

	lspipe = rootcmdpopen(NULL /* No chroot! */,"/tmp",
			      ftp_uid,-1,_PATH_ARCHIE,
			      argstr,
			      "rGE",
			      &archie_pid);

	/* Pipe forks ARCHIE in /tmp directory.  Let it run there... */

	if (lspipe == NULL) {
	  fprintf(outfile,"** Failed to start ARCHIE program!\n\n");
	  return 63;
	}

	strcpy(tempname,MsrvTempName);
	tmpfil = fdopen(mkstemp(tempname),"w+");
	if (tmpfil == NULL) {
	  fprintf(outfile,"\
** Ouch!  Can't create temporary file!\n\
** You get only first 60 lines, rest will be flushed!\n");
	  while (lines < 60 && !feof(lspipe) && !ferror(lspipe)) {
	    register int c = getc(lspipe);
	    if (c == EOF) break;
	    putc(c,outfile);
	    if (c == '\n') ++lines;
	  }
	  rootcmdpclose(lspipe);
	  alarm(0);
	  signal(SIGALRM,SIG_IGN);
	  fprintf(outfile,"** Done with it -- without tmp file%s\n",
		  lines >= 60 ? ", chopped at 60 lines" : "");
	} else {
	  /* We have temp file.  Lets see what we do... */
	  register int c;
	  while (!feof(lspipe) && !ferror(lspipe) && !ferror(tmpfil)) {
	    if ( (c = getc(lspipe)) == EOF ) break;
	    putc(c,tmpfil);
	    if (c == '\n') ++lines;
	  }
	  rootcmdpclose(lspipe);
	  alarm(0);
	  signal(SIGALRM,SIG_IGN);
	  fflush(tmpfil);
	  if (lines < 60) {
	    fprintf(outfile,"*## Short listing, %d lines:\n*:",lines);
	    fseek(tmpfil,0,0);		/* rewind() */
	    while (!feof(tmpfil) && !ferror(tmpfil)) {
	      if ((c = getc(tmpfil)) == EOF) break;
	      putc(c,outfile);
	      if (c == '\n') fputs("*:",outfile);
	    }
	    fprintf(outfile,"*## end of listing\n");
	  } else {
	    /* Big.. Mail it in pieces.. */
	    sprintf(tmpstr,"ARCHIE %s",argstr);
	    mail_reply(tempname,Cmd,Hdr,outfile,lines,tmpstr);
	  }
	}
	if (tmpfil) fclose(tmpfil);
	unlink(tempname);

	return 0;
#else
	fprintf(outfile,"** Sorry, we don't have ARCHIE interface enabled!\n");
	return 1;
#endif
}
