/* ************************************************************ *
 *								*
 *		CMD-CMDS.H					*
 *	Include from  input.h				*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

#ifndef	CMD_INPUT_C
extern struct command Commands[];
#else

struct command Commands[] = {
  { "HELP",	do_help,	"Give help on recognized commands" },
  { "APUA",	do_help,	"Give help on recognized commands - Finnish" },
  { "SUBSCRIBE", do_subscribe,	"UNIX mailserver style mailing list subscribe."},
  { "SUBS",	do_subscribe,	"UNIX mailserver style mailing list subscribe."},
  { "SUB",	do_subscribe,	"UNIX mailserver style mailing list subscribe."},
  { "ADD",	do_subscribe,	"UNIX mailserver style mailing list subscribe."},
  { "SIGNON",	do_subscribe,	"UNIX mailserver style mailing list subscribe."},
  { "TILAA",	do_subscribe,	"UNIX mailserver style mailing list subscribe - in Finnish."},
  { "UNSUBSCRIBE", do_unsubscribe, "UNIX mailserver style mailing list unsubscribe."},
  { "UNSUBS",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe."},
  { "UNSUB",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe."},
  { "DELETE",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe."},
  { "POISTU",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe - Finnish"},
  { "POISTA",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe - Finnish"},
  { "SIGNOFF",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe."},
  { "SIGNOF",	do_unsubscribe, "UNIX mailserver style mailing list unsubscribe."},
  { "LIST",	do_listmaillists, "List of accessible mailing lists at this host."},
  { "LISTA-LUETTELO",	do_listmaillists, "List of accessible mailing lists at this host - Finnish"},
  { "LISTALUETTELO",	do_listmaillists, "List of accessible mailing lists at this host - Finnish"},
  { "REVIEW",	do_listreview,	"Output list intro header and members of list."},
  { "REV",	do_listreview,	"Output list intro header and members of list."},
  { "REVME",	do_listrevme,	"Search which list(s) I am on."},
  { "/PDGET",	do_pdget,	"`TRICKLE' style file retrieval system."},
  { "/PDDIR",	do_pddir,	"`TRICKLE' style directory retrieval system."},
  { "PARTSIZE",	do_partsize,	"File server delivery data feature."},
  { "PARTS",	do_parts,	"File server delivery data feature."},
  { "PART",	do_parts,	"File server delivery data feature."},
  { "MAILQUOTA", do_mailquota,	"File server delivery data feature."},
  { "PALAKOKO",	do_partsize,	"File server delivery data feature - Finnish"},
  { "PALA",	do_parts,	"File server delivery data feature - Finnish"},
  { "PALAT",	do_parts,	"File server delivery data feature - Finnish"},
  { "SIZE",	do_partsize,	"File server delivery data feature."},
  { "ENCODER",	do_encoding,	"File server delivery data feature."},
  { "ENCODE",	do_encoding,	"File server delivery data feature."},
  { "KOODAUS",	do_encoding,	"File server delivery data feature - Finnish"},
  { "LOCATE",	do_locate,	"File server delivery data feature."},
  { "FIND",	do_locate,	"File server delivery data feature."},
  { "ETSI",	do_locate,	"File server delivery data feature - Finnish"},
  { "CHDIR",	do_chdir,	"File server delivery data feature."},
  { "CD",	do_chdir,	"File server delivery data feature."},
  { "SIIRRY",	do_chdir,	"File server delivery data feature - Finnish"},
  { "PWD",	do_chdir,	"File server delivery data feature."},
  { "HAKEMISTO",do_chdir,	"File server delivery data feature - Finnish"},
  { "DIR",	do_filedir,	"File server delivery data feature."},
  { "LS",	do_filedir,	"File server delivery data feature."},
  { "SEND",	do_filesend,	"File server delivery data feature."},
  { "SENDME",	do_filesend,	"File server delivery data feature."},
  { "SHOPMARK",	do_shopmark,	"File server delivery data feature."},
  { "SHOP",	do_shopmark,	"File server delivery data feature."},
  { "REPLYTO",	do_replyto,	"Basic server utilities."},
  { "REPLY-TO",	do_replyto,	"Basic server utilities."},
  { "REPLY-TO:",do_replyto,	"Basic server utilities."},
  { "POLKU",	do_replyto,	"Basic server utilities."},
  { "PALUUOSOITE", do_replyto,	"Basic server utilities."},
  { "PALUU-OSOITE", do_replyto,	"Basic server utilities."},
  { "PATH",	do_replyto,	"Basic server utilities."},
  { "ARCHIE",	do_archie,	"Prospero ARCHIE interface."},
  { NULL,	NULL,		NULL }
};

#endif
