/* ************************************************************ *
 *								*
 *		CMD-FILESTATS.C					*
 *								*
 *	A part of main piece of mail (and other) servers.	*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>

#include "config.h"

#if	HAS_FILESTORE	/* From config.h */

extern int errno;

#ifndef	S_ISDIR
#define S_ISDIR(mode)	((S_IFMT & (mode)) == S_IFDIR)
#endif
#ifndef	S_ISREG
#define S_ISREG(mode)	((S_IFMT & (mode)) == S_IFREG)
#endif

#include "input.h"
#include "filestats.h"

extern DBM *dbm_open __((char *file, int flags, int mode));
extern void dbm_close __((DBM * db));
extern datum dbm_fetch __((DBM *db, datum key));
extern int dbm_store __((DBM *db, datum key, datum content, int flags));
extern int dbm_delete __((DBM *db, datum key));
extern datum dbm_firstkey __((DBM *db));
extern datum dbm_nextkey __((DBM *db));
/* extern int dbm_error __((DBM *db));	  */	/* macros! */
/* extern int dbm_clearerr __((DBM *db)); */
/* extern int dbm_dirfno __((DBM *db));   */
/* extern int dbm_pagfno __((DBM *db));   */
/*	typedef struct {		*/
/*		char	*dptr;		*/
/*		int	dsize;		*/
/*	} datum;			*/

/*
struct SendStats {
	long	orderedbytes;
	int	orderedfiles;
};
*/

extern char *strchr(), *strrchr();
extern char *malloc();
extern void  free();
extern int  errno;
extern char *sys_errlist[];



/* ****************************************************************
 *
 *  Some statistics routines for do_filesend()
 *
 * **************************************************************** */

/* lock while open... */
DBM *
flopen_order_stat_file(fname)
char *fname;
{
	DBM *db = dbm_open(fname,O_CREAT|O_RDWR,0644);
	if (!db) return NULL; /* FAILED ! */
#ifdef BSD
	if (flock(dbm_dirfno(db),LOCK_EX)) {	/* Blocking lock! */
	  /* It failed! */
	  dbm_close(db);
	  return NULL;
	}
#endif	
	return db;
}

struct SendStats *
OrdersQuery(db,replypath)
DBM *db;
char *replypath;
{
	datum key;
	datum result;
	static struct SendStats SS0 = { 0,0 };
	    
	key.dptr = replypath;
	key.dsize = strlen(replypath);

	result = dbm_fetch(db,key);
	if (result.dptr)
	  return((struct SendStats *)result.dptr);
	return(&SS0);
}

int
OrderStatUpdate(db,replypath,stats)
DBM *db;
char *replypath;
struct SendStats *stats;
{
	datum key;
	datum content;

	key.dptr = replypath;
	key.dsize = strlen(replypath);
	content.dptr = (void*) stats;
	content.dsize = sizeof (struct SendStats);
	return(dbm_store(db,key,content));
}
#else /* !HAS_FILESTORE */
static void nothing_in_filestats_c() {}
#endif /* !HAS_FILESTORE */
