# listserv
#
# 25-Jun-92 weber@eitech.com updated to new parameter format
# 1-Jun-92 weber@eitech.com
#
# Copyright (c)  1992 Enterprise Integration Technologies Corporation
#
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the name of
# Enterprise Integration Technologies Corporation may not be used in any 
# advertising or publicity relating to the software without the specific, 
# prior written permission of Enterprise Integration Technologies Corporation.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
#
# IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
# LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
# ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
# THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
# This service mimicks some of the commands in the listserv package
# for mailing list maintenance.  Mailing lists must be manually created;
# e.g., to create a list called "mylist", do a "touch ~/Lists/mylist" and
# then add the following line to your system's /etc/aliases file:
# "mylist: :include:~/Lists/mylist" (where you have to replace the "~"
# with services' home directory on your system).
#
proc listserv {switches envelope inputs} {
    cd ~/Lists
    if {$switches == ""} {
	catch {set switches [exec cat [getfield $inputs FILE]]}
	if {[llength $switches] == 0} {set switches "help"}
    }
    set mlist [string tolower [lindex $switches 1]]
    case  [string tolower [lindex $switches 0]] {
	subscribe {
	    if {[file exists $mlist]} {
		set fid [open $mlist a]
		puts $fid [format "%s (%s)" \
		  [getfield $envelope REPLYTO] [lrange $switches 2 end]]
		close $fid
		setfield response STRING \
		  "You are now on the $mlist mailing list."
	    } {
		setfield response STRING \
		  "Sorry, I don't maintain a $mlist mailing list."
	    }
	}
	{ unsubscribe signoff }  {
	    if {[file exists $mlist]} {
		exec mv $mlist $mlist.bak
		catch "exec grep -v -i \
		  [getfield $envelope REPLYTO] $mlist.bak > $mlist"
		setfield response STRING \
		  "You have been removed from the $mlist mailing list."
	    } {
		setfield response STRING \
		  "Sorry, I don't maintain a $mlist mailing list."
	    }
	}
	{ recipients review } {
	    if {[file exists $mlist]} {
		setfield response FILE $mlist
	    } {
		setfield response STRING \
		  "Sorry, I don't maintain a $mlist mailing list."
	    }
	}
	information {
	    if {[file exists $mlist.txt]} {
		setfield response FILE $mlist.txt
	    } {
		setfield response STRING \
		  "Sorry, I don't have information on the $mlist mailing list."
	    }
	}
	lists {
	    setfield response STRING [glob {*}]
	    setfield response DESCRIPTION "ServiceMail mailing lists at [exec hostname]"
	}
	help {
	    setfield response FILE ~/src/man/listserv.man
	    setfield response DESCRIPTION "help regarding ServiceMail(tm) listserv"
	}
	default {
	    setfield response STRING \
	      "Sorry, I don't support the listserv command '"[lindex $switches 0]"'"
	}
    }
    return [mailout [turnaround $envelope] $response]
}
