/* 
 * Routines for printing arguments and return values of system 
 * calls. By default, the system calls will call printargs_gen(),
 * if no specialised one for them has been written.
 * $Id: print_gen.c,v 1.4 1993/11/23 03:07:14 anthony Exp $
 */
#include "trace.h"
#include "sysname.h"

extern FILE *outfp;
extern int max_string;

static char *sysn;

int printargs_gen(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char *p; 
    int reg=0;

    sysn = sysFormat;
    p = strchr(sysn,'(');
	
    fprintf(outfp,"%.*s (", p++ - sysn, sysn);

    for(; *p != ')'; *++p != ')' && fprintf(outfp,", ")) {
	p_arg(*p, sysArgs[reg++], sysArgs[reg]);
    }
    fprintf(outfp,") = ");

    if (sysCallno == SYS_exit)
	fprintf(outfp,"(0)\n");
    return(1);
}

int printret_gen(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn != -1) {
	if (sysn)
	    p_arg(sysn[strlen(sysn)-1], sysReturn, max_string);

    } else {
	/* sigreturn seems to set $19 to 1, but $0 to -2 EJUSTRETURN */
	if (sysErrno >= 0 && sysErrno <= sys_nerr)
	    fprintf(outfp," -1, (%s)",sys_errlist[sysErrno]); 
	else {
	    switch(sysErrno) {
		case -2: fprintf(outfp," EJUSTRETURN "); break;
		case -1: fprintf(outfp," ERESTART "); break;
		default: p_arg(sysn[strlen(sysn)-1], sysErrno, max_string); break;
	    }
	}
    } 
    fputc('\n', outfp);
    return(1);
} 
