/* 
 * print_io : print_ routines for open() read() flock() lseek() calls
 * Author: Matti Aarnio <mea@nic.funet.fi>
 */

#include <string.h>
#include <sys/fcntl.h>
#include "trace.h"
#include "sysname.h"
#define USE_IOCTLTABLE
#include "ioctltable.c"

extern FILE *outfp;
extern int max_string;

/* We collect a HUGE collection of IOCTLs here for a table.. */

static char *iocs_name(ioc)
int ioc;
{
	int lo, hi,mid;
	lo = 0;
	hi = iocs_cnt;
	while (lo <= hi) {
	  mid = (lo + hi) >> 1;
	  if (iocs[mid].val == ioc)
	    return iocs[mid].name;
	  if (iocs[mid].val > ioc)
	    lo = mid+1;
	  else
	    hi = mid-1;
	}
	return NULL;
}

/* 
 * ioctl.
 */
   
int printargs_ioctl(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char what[30];
    char grp[8];
    int ioc0 =  sysArgs[1] & 0xFF;	    /* num   */
    int ioc1 = (sysArgs[1] >>  8) & 0xFF;   /* group */
    int ioc2 = (sysArgs[1] >> 16) & 0x1FFF; /* len   */
    int ioc3 =  sysArgs[1] & IOC_DIRMASK;   /* inout */

    char *ioc_name = iocs_name(sysArgs[1]);

    if (' ' <= ioc1  && ioc1 <= 0x7E)
      sprintf(grp,"'%c'",ioc1);
    else
      sprintf(grp,"'\\%o'",ioc1);

    switch(ioc3) {
    case IOC_VOID:
        sprintf(what,"_IO(%s,%d)",grp,ioc0);
	break;
    case IOC_OUT:
	sprintf(what,"_IOR(%s,%d,%d)",grp,ioc0,ioc2);
	break;
    case IOC_IN:
	sprintf(what,"_IOW(%s,%d,%d)",grp,ioc0,ioc2);
	break;
    case IOC_INOUT:
	sprintf(what,"_IOWR(%s,%d,%d)",grp,ioc0,ioc2);
	break;
    default:
	sprintf(what,"_IOC??(0x%x,%s,%d,%d)",ioc3,grp,ioc0,ioc2);
	break;
    }
    if (ioc_name != NULL)
      fprintf(outfp,"ioctl (%d, %s [%s], 0x%p) = ",(int)sysArgs[0],ioc_name,what,(void*)sysArgs[2]);
    else
      fprintf(outfp,"ioctl (%d, %s, 0x%p) = ",(int)sysArgs[0],what,(void*)sysArgs[2]);
    return(1);
}

int printret_ioctl(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
	fprintf(outfp,"%d\n",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return(1);
} 
