/* 
 * print_open : print_ routines for open() system call.
 * Author: Anthony Baxter <anthony@aaii.oz.au>
 * $Id: print_mmap.c,v 1.2 1993/12/21 23:50:34 anthony Exp $
 */
#include <string.h>
#include "trace.h"
#include "sysname.h"

extern FILE *outfp;
extern int max_string;

#include <sys/types.h>
#include <sys/mman.h>

/*
 * caddr_t mmap (
 *         caddr_t addr,
 *         size_t len,
 *         int prot,
 *         int flags,
 *         int filedes,
 *         off_t off );
 */
int printargs_mmap(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char *hack=" ";
    int protflag=(int)sysArgs[2];
    int attrflag=(int)sysArgs[3];

    fprintf(outfp,"mmap ( 0x%p, %ld,",sysArgs[0],sysArgs[1]);
    if( !( (protflag & PROT_READ) || (protflag & PROT_WRITE) || (protflag & PROT_EXEC) ) )
	fprintf(outfp, "NONE (%ld), ",protflag);
    else {
	hack=" ";
	if (protflag & PROT_READ) {
	    fprintf(outfp, "%sREAD",hack); hack="|";
	}
	if (protflag & PROT_WRITE) {
	    fprintf(outfp, "%sWRITE",hack); hack="|";
	}
	if (protflag & PROT_EXEC) {
	    fprintf(outfp, "%sEXEC",hack); 
	}
	fprintf(outfp,",");
    }

    if( !( (attrflag & MAP_FILE) || (attrflag & MAP_ANONYMOUS) || (attrflag & MAP_VARIABLE || 
             ((attrflag & MAP_FIXED) || (attrflag & MAP_SHARED))) || (attrflag & MAP_PRIVATE) ) )
	fprintf(outfp,"0, ");
    else {
	hack=" ";
	if (attrflag & MAP_FILE) {
	    fprintf(outfp, "FILE"); hack="|";
	}
	if (attrflag & MAP_ANONYMOUS) {
	    fprintf(outfp, "%sANONYMOUS",hack); hack="|";
	}
	if (attrflag & MAP_VARIABLE) {
	    fprintf(outfp, "%sVARIABLE",hack); hack="|";
	}
	if (attrflag & MAP_FIXED) {
	    fprintf(outfp, "%sFIXED",hack); hack="|";
	}
	if (attrflag & MAP_SHARED) {
	    fprintf(outfp, "%sSHARED",hack); hack="|";
	}
	if (attrflag & MAP_PRIVATE) {
	    fprintf(outfp, "%sPRIVATE",hack); 
	}
	fprintf(outfp,", ");
    }
    fprintf(outfp, "%ld, 0x%p ) = ",sysArgs[4],sysArgs[5]);

    return(1);
}

int printret_mmap(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn != -1)
        fprintf(outfp,"0x%p\n",sysReturn);
    else
        fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return 1;
} 
