/* 
 * print_table : print_ routines for table() system call.
 * Author: Anthony Baxter <anthony@aaii.oz.au>
 * $Id: print_table.c,v 1.1 1993/11/23 03:08:26 anthony Exp $
 */
#include <string.h>
#include <sys/table.h>
#include "trace.h"
#include "sysname.h"

extern FILE *outfp;
extern int max_string;

#include <sys/fcntl.h>

/*
 * int table(id, index, addr, nel, lel)
 *         int id;        ID of table 
 *         int index;     index 
 *         char *addr;    address of struct for returned data 
 *         int nel;       number of elements
 *         u_int lel;     size of an element 
 */

int printargs_table(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    char table_flags_b[100], *table_flags = table_flags_b;
    char *idstr;
    int id=(int)sysArgs[0];

    switch(id) {
	case TBL_TTYLOC :	idstr="TTYLOC"; break;
	case TBL_U_TTYD :	idstr="U_TTYD"; break;
	case TBL_UAREA :	idstr="UAREA"; break;
	case TBL_LOADAVG :	idstr="LOADAVG"; break;
	case TBL_INCLUDE_VERSION :  idstr="INCLUDE_VERSION"; break;
	case TBL_FSPARAM :	idstr="FSPARAM"; break;
	case TBL_ARGUMENTS :	idstr="ARGUMENTS"; break;
	case TBL_MAXUPRC :	idstr="MAXUPRC"; break;
	case TBL_AID :		idstr="AID"; break;
	case TBL_MODES :	idstr="MODES"; break;
	case TBL_PROCINFO :	idstr="PROCINFO"; break;
	case TBL_ENVIRONMENT :	idstr="ENVIRONMENT"; break;
	case TBL_SYSINFO :	idstr="SYSINFO"; break;
	case TBL_DKINFO :	idstr="DKINFO"; break;
	case TBL_TTYINFO :	idstr="TTYINFO"; break;
	case TBL_MSGDS :	idstr="MSGDS"; break;
	case TBL_SEMDS :	idstr="SEMDS"; break;
	case TBL_SHMDS :	idstr="SHMDS"; break;
	case TBL_MSGINFO :	idstr="MSGINFO"; break;
	case TBL_SEMINFO :	idstr="SEMINFO"; break;
	case TBL_SHMINFO :	idstr="SHMINFO"; break;
	case TBL_INTR :		idstr="INTR"; break;
	case TBL_SWAPINFO :	idstr="SWAPINFO"; break;
	default:		idstr="????"; break;
    }

    
    fprintf(outfp,"table (%s, %d, 0x%x, %d, %d) = ",idstr,sysArgs[1],
                  sysArgs[2],sysArgs[3],sysArgs[4]);
    return(1);
}

int printret_table(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
        fprintf(outfp,"%d\n",(int)sysReturn);
    else
        fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return 1;
} 
