
#include "nc.h"
/*
 * Variable argument, general tree node creation routine.
 *
 * Given the node type and some kids, it builds a tree node for
 * you.
 */
 /*
  * Newsclip(TM) Compiler Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip compiler for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed before compiling.
  * A short time evaluation of this product is also permitted.  See the file
  * 'Licence' in the library source directory for details.
  */

/*VARARGS1*/
nodep 
tree(type, a1, a2, a3, a4)
byte type;		/* node type */
nodep a1, a2, a3, a4;	/* various args */
{
	register nodep	newnode;	/* pointer to built node */
	int		num;
	int i;
	extern struct node_info node_table[];
	extern int yylineno;		/* curent parser line number */

	num = node_table[type].fullkids;

	newnode = (nodep)checkalloc(sizeof(struct node)+sizeof(nodep)*(num-1));

	newnode->ntype = type;
	newnode->nflags = 0;

	switch (num) {
	case 4:
		newnode->kids[3] = a4;
	case 3:
		newnode->kids[2] = a3;
	case 2:
		newnode->kids[1] = a2;
	case 1:
		newnode->kids[0] = a1;
	case 0:
		break;
	default:
		break;
		}
	num = node_table[type].kids;
	newnode->line_num = yylineno;
	/* now loop and set the parents */
	for( i = 0; i < num; i++ ) {
		nodep kid;
		kid = newnode->kids[i];
		if( kid )
			kid->parent = newnode;
		}
	return newnode;
}

/* Turn a node into a linked list element.  If already a list, return it */

listp
freshlist( node )
nodep node;		/* the single node to form into a list */
{
	listp newlist;
	extern int yylineno;
	extern char *yyfilename;

	if( node == NIL || node->ntype != N_LIST ) {
		newlist = (listp)checkalloc( sizeof(struct link_list) );
		newlist->kid = node;
		newlist->next = (listp)0;
		newlist->line_num = yylineno;
		newlist->filename = yyfilename;
		newlist->parent = NIL;
		newlist->ntype = N_LIST;
		if( node != NIL )
			node->parent = (nodep)newlist;
		return newlist;
		}
	 else
		return (listp)node;
}

/* Join two lists, two nodes or a node an a list together in a linked list */

listp
llist( n1, n2 )
nodep n1;		/* the list we are joining to - or perhaps a node? */
nodep n2;		/* the node to add -- or possibly another list */
{
	listp main, scan;
	listp addon;

	main = freshlist(n1);

	/* chain to the end of the first list */
	for( scan = main; scan->next; scan = scan->next )
		;
	addon = freshlist(n2);
	scan->next = addon;
	addon->parent = (nodep)scan;
	return main;
}

/* compare two argument lists for two routines */

bool
arglists_match( l1, l2 )
struct typelist *l1;		/* the user declared list */
struct typelist *l2;		/* the system defined list */
{
	int i;
	int checkcount;

	if( l1->argcount >= l2->argmin && l1->argcount <= l2->argmax ) {
		checkcount = min( l1->argcount, l2->argcount );
		for( i = 0; i < checkcount; i++ )
			if( l1->args[i] != l2->args[i] )
				return FALSE;
		return TRUE;
		}
	return FALSE;
}

char *
findfile( tp )
nodep tp;
{
	extern char *yyfilename;;

	while( tp && tp->ntype != N_LIST )
		tp = tp->parent;
	if( tp )
		return ((listp)tp)->filename;
	 else
		return yyfilename;
}

/* Free up a code tree  - a recursive routine */

treefree(np)
nodep np;
{
	extern struct node_info node_table[];
	int fkids;			/* number of kids to free */
	int i;

	if( np == NIL )
		return;


	if( np->ntype == N_LIST ) {
		listp flist;
		for( flist = (listp)np; flist; flist = flist->next ) {
			treefree( flist->kid );
			free( flist );
			}
		return;
		}
	 else {
		fkids = node_table[np->ntype].kids;
		for( i = 0; i < fkids; i++ ) 
			treefree( np->kids[i] );
		}

	switch( np->ntype ) {
		case N_STRING:
			free( (char *)kid0(np) );
			break;
		/* We do not free IDs, we leave that up to the freeing of
		   the symbol table */
		}
	/* get rid of ourselves and go */
	free( np );
}
