
/*
 * This file returns site-dependent and user-dependent information
 * It may be necessary to edit and ajust this file on different variants
 * of Unix, although we have tried to deal with many of them.  I wish
 * they wouldn't keep adding more.
 */
 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  * Use of this code for a short term evaluation of the product, as defined
  * in the associated file, 'Licence', is permitted.
  */


#include "nl.h"

#include <pwd.h>

char *homedir;		/* home directory */
char *dotdir;		/* dot directory */
char *userid;		/* the userid of the user */
char *logname;		/* login name */
char *fullname;		/* full name */
char *sitename;		/* short site name of my site */
char *my_domain;	/* domain name of my site */
char *my_mail_address;	/* my internet mail address */
char *newsrcname = 0;	/* name for .newsrc file */
char *lasname = 0;	/* last article seen file */
char *temprc = 0;	/* tempory newsrc to write out */

char *news_lib_dir;
char *news_spool_dir;

bool normal_newsrc = FALSE;	/* are we using the standard newsc file? */

/* There is no reliable method for getting the full mail domain name that
   is used in mail addresses.  The only way is for the person who compiled
   the program to have set the proper defines.  Some day this routine will
   do something.    We *can* get the site name, but that's not all that
   useful to us for checking mail addresses, and it's a messy, multi-ifdef
   procedure that we don't need to have around unless it's necessary. */

char *
get_domain(site)
char *site;
{
#ifdef MAILDOMAIN
	return MAILDOMAIN;
#else
	char *ret;
	ret = perm_alloc( strlen(site) + 5 + 1 );
	/* default domain of uucp is quite probably wrong */
	sprintf( ret, "%s.%s", site, DEFDOMAIN );
	return ret;
#endif
}

#ifdef HAS_UNAME
#include <sys/utsname.h>
#endif

char *
get_sitename()
{
	char snbuf[50];
	FILE *sysid;
#ifdef GETHOSTNAME
	gethostname(snbuf,sizeof(snbuf));
	return allocstring(snbuf);
#else
	if( sysid = fopen( "/etc/systemid", "r" ) ) {
		int len;
		if( fgets( snbuf, sizeof(snbuf), sysid ) ) {
			fclose( sysid );
			len = strlen( snbuf );
			if( len && snbuf[len-1] == '\n' )
				snbuf[len-1] = 0;
			return allocstring( snbuf );
			}
		fclose( sysid );
		}
# ifdef HAS_UNAME
	{
	struct utsname nam;
	uname( &nam );
	return allocstring( nam.nodename );
	}
# else /*HAS_UNAME*/

#  ifndef sysname
#  define sysname "unknown"
	warning( 2, "System name is unknown.\n" );
#  endif
	return sysname;		/* often defined in whoami.h */
	
# endif /*HAS_UNAME*/

#endif /*GETHOSTNAME*/

}

/* concatenate three strings together in a newly allocated buffer */
/* used mostly to add a directory name, slash and filename together */

char *
catnames( s1, s2, s3 )
char *s1, *s2, *s3;
{
	unsigned int len, l1, l2;
	char *ret;

	l1 = strlen(s1);
	l2 = strlen(s2);
	len = l1 + l2 + strlen(s3);
	ret = perm_alloc( len+1 );
	strcpy( ret, s1 );
	strcpy( ret+l1, s2 );
	strcpy( ret+l1+l2, s3 );
	return ret;
}

init_whoami()
{
	int uid;
	struct passwd *pwent, *getpwuid();
	extern char *getlogin();
	extern char *getenv AC((char *));
	char buf[MAX_LLEN];


	if( !( homedir = getenv( "HOME" ) ) )
		homedir = getenv( "LOGDIR" );

	fullname = getenv( "NAME" );

	uid = getuid();

	if( pwent = getpwuid( uid ) ) {
		userid = allocstring( pwent->pw_name );
		if( !fullname ) {
			char *p;
			/* theory is the comma should only be a delimiter
			   on certain systems */
			p = strchr( pwent->pw_gecos, ',' );
			if( p )
				*p = 0;
			fullname = allocstring( pwent->pw_gecos );
			/* theory is that '&' should map to the userid but
			   I can't imagine why in hell that should be */
			}
		if( !homedir )
			homedir = allocstring( pwent->pw_dir );
		}
	 else 	/* give up and use a dummy name */
		userid = "fbaggins";

	if( !( logname = getenv("USER") ) )
		if( !( logname = getenv( "LOGNAME" ) ) )
			if( logname = getlogin() )
				logname = allocstring( logname );
			 else
				logname = userid;

	/* Now get the site name */
	sitename = get_sitename();
	my_domain = get_domain( sitename );
	sprintf( buf, "%s@%s", userid, my_domain );
	my_mail_address = allocstring( buf );

	/* if we still don't have a full name, use the mail address */
	if( !fullname )
		fullname = my_mail_address;

	if( !dotdir )
		if( !( dotdir = getenv( "DOTDIR" ) ) )
			dotdir = homedir;
	if( !newsrcname ) {
		if( !( newsrcname = getenv( "NEWSRC" ) ) ) {
			newsrcname = catnames( dotdir, "/", ".newsrc" );
			normal_newsrc = TRUE;
			}
		}
	if( !lasname )
		lasname = catnames( newsrcname, "las", "" );
	temprc = catnames( newsrcname, "new", "" );

	/* set up news library and spool directories */
	if( !news_lib_dir )
		news_lib_dir = NEWSLIB;
	if( !news_spool_dir )
		news_spool_dir = NEWSSPOOL;
}

/* If your system has no getlogin, define this null one.  It's not important,
   unless you can plug in some other username finding routine.  This is
   the routine of last resort.  If it returns null, as this dummy does,
   you get a dummy name.  That's ok.  Ther user simply can't use the
   "my_mail_address" variable in this case -- they have to enter it by
   hand. */

#ifndef GETLOGIN

char *
getlogin()
{
	return (char *)0;
}
#endif

datehold time_now;		/* the time we ran */
int zone_offset;		/* offset from GMT in minutes */
#include <time.h>

/* Find the time, and the timezone offset from GMT in minutes.  The way
   to find this out varies from OS variant to OS variant, but I believe
   I have a reasonably portable way below. */

init_time()
{
	struct tm *tbuf;
	long day1, time();

	time_now = time((long*)0);
	/* the most portable way I currently know to get the time zone
	   adjustment is to get the time of day for Midnight on the second
	   day of the epoch from the localtime function.  Some systems
	   require an init routine to be called to set up time zone stuff
	   properly, and that can be inserted here.  It's worth nothing
	   that getting this value right isn't super crucial.  It has
	   only a minor effect on the parsing of dates, and usually dates
	   aren't even bothered with by newsclip programs */

	day1 = 60*60*24;		/* one day of seconds */

	tbuf = localtime( &day1 );
	/* In this case, it's minutes WEST of GMT, which is positive for
	   us western guys */
	if( tbuf->tm_hour >= 12 )
		zone_offset = 60 * (24-tbuf->tm_hour) - tbuf->tm_min;
	 else
		zone_offset = -60 * tbuf->tm_hour - tbuf->tm_min;
}

/* Some routines missing from BSD Unix */

#ifdef NEED_SLIB


/* strpbrk, like strchr, but searches for any one of a set of chars */

char *
strpbrk( str, lchars )
char *str;		/* string to search in */
char *lchars;
{
	register char *p;

	for( p = str; *p; p++ )
		if( strchr( lchars, *p ) )
			return p;
	return (char *)0;
}

/* strtok - string parsing routine */

static char *tokstring;

char *
strtok( string, delims )
char *string;		/* string to parse, or null to continue old string */
char *delims;		/* delimiters to parse on */
{
	register char *p, *del;		/* scanning pointer */
	char *start;

	p = string ? string : tokstring;

	/* skip over initial delimiters */
	while( *p ) {
		for( del = delims; *del; del++ )
			if( *del == *p )
				goto nextc;
		break;		/* not a delim */
		nextc: p++;
		}
			
	if( !*p )
		return NULL;

	start = p;

	/* go to next delimiter */
	while( *p ) {
		for( del = delims; *del; del++ )
			if( *del == *p )
				goto tok_done;
		p++;
		}
	tok_done:
	/* store 0 on top of delimiter */
	if( *p )
		*p++ = 0;
	/* save in static for next call */
	tokstring = p;

	return start;
}

/*
 * The following is provided for those people who do not have strcspn() in
 * their C libraries.  They should get off their butts and do something
 * about it; at least one public-domain implementation of those (highly
 * useful) string routines has been published on Usenet.
 */
/*
 * strcspn - find length of initial segment of s1 consisting entirely
 * of characters not from s2  (Henry Spencer)
 */

static int
strcspn(s1, s2)
char *s1;
char *s2;
{
	register char *scan1;
	register char *scan2;
	register int count;

	count = 0;
	for (scan1 = s1; *scan1 != '\0'; scan1++) {
		for (scan2 = s2; *scan2 != '\0';)	/* ++ moved down. */
			if (*scan1 == *scan2++)
				return(count);
		count++;
	}
	return(count);
}
#endif /*NEED_SLIB*/
