
/* TRACE PACKAGE HEADER FILE
** The invoking package must define MAX_DEBUG_LEVEL and MAX_DEBUG_SUBLEVEL
** These are used in the trace package to declare the debug_flags array.
**
** Defines:
** 	INIT_DEBUG(TRUE_LEVELS, TRUE_SUBLEVELS)
**	START_DEBUG(level,sublevel)
**	END_DEBUG
*/

#ifndef MAX_DEBUG_LEVEL
    error: MAX_DEBUG_LEVEL must be defined
#endif

#ifndef MAX_DEBUG_SUBLEVEL
    error: MAX_DEBUG_SUBLEVEL must be defined
#endif

#ifndef DEBUG_H


    /* If the debug file has not been included, do the defines */
#define DEBUG_H

#ifdef DEBUG_ON

/*
** Declare debug_flags as an external array because it is used in the defines.
*/

extern int debug_flags[MAX_DEBUG_LEVEL] [MAX_DEBUG_SUBLEVEL];


/* 
** Define everything the way it is when debug code is desired.
**
** ASSERT(bool_exp, level, sublevel, string);
**      If debug_flags[level, sublevel] is true and the logical expression
**	is false, call print_trace with the string.
** INIT_DEBUG	- call init_debug;
** START_DEBUG(level, sublevel);
**	If debug_flags[level, sublevel] is set, include the code until
**	END_DEBUG.
** END_DEBUG 
**	Markes the end of a section of debug code.
*/

#define DEBUG(level,sublevel)		if ( debug_flags[level][sublevel]
#define START_DEBUG(level,sublevel)	if ( debug_flags[level][sublevel] ) {
#define END_DEBUG			}
#define INIT_DEBUG			init_debug()
#else

/* 
** Define everything so that no debug code is generated.
*/

#define DEBUG(level,sublevel)
#define START_DEBUG(level,sublevel)	if ( 0 ) {
#define END_DEBUG			}
#define INIT_DEBUG

#endif
#endif
