/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/inotes.c,v 1.1 89/02/07 19:54:00 gore Exp $ */

/*
 *	inotes - post a message to the notesfile
 *
 *	We read the arguments (and any supplied header lines)
 *	and then verify permissions.
 *	If everything is OK we post the article.
 *
 *	TODO: support for headers, responses
 */

#include "parms.h"
#include "structs.h"
#include "header.h"

int re_seen = 0;
#ifdef __STDC__
char *gettitle(char*);
#else
char *gettitle();
#endif

main(argc, argv)
char **argv;
{
	struct io_f io;
	struct note_f note, note2;
	char *nfname, *ntitle, *nfrom;
	int stat, anon, i;
	struct hbuf h;

	initenv();

	if (argc == 1) {		/* not even a notefile - bad */
	    usage (argv[0]);
	    exit(BAD);
	}
	stat = anon = 0;			/* set up flags and such */
	ntitle = nfname = nfrom = 0;
	for (i = 1; i < argc; i++) {
		switch (argv[i][1]) {
		case 'n':
			nfname = argv[++i];	/* point notefile name */
			break;
		case 'd': 
			/* enable director message */
			stat = DIRMES;
			break;
		case 't': 	/* this one is the title */
			ntitle = argv[++i];		/* grab title */
			break;
		case 'f':	/* from who */
			nfrom = argv[++i];
			break;
		case 'a': 
			anon = 1;
			break;
		default: 
			fprintf(stderr, "Bad switch: %c\n", argv[i][1]);
			usage (argv[0]);
			exit(BAD);
		}
	}
	if (ntitle == 0 || nfname == 0) {
		fprintf(stderr, "Please specify a title and notesfile\n");
		exit(BAD);
	}
	if (init(&io, nfname) < 0) {
		fprintf(stderr, "%s: no such notesfile\n", nfname);
		exit(NONF);
	}
	if ((io.access & WRITOK) == 0) {
		fprintf(stderr, "%s: no write permission\n", io.nf);
		finish(&io);
		exit(BAD);
	}
	if (allow(&io, DRCTOK) == 0)
		stat &= ~DIRMES;
	if ((io.descr.d_stat & ANONOK) == 0)
		anon = 0;

	safecpy(note.n_title, gettitle(ntitle), TITLEN);
	note.n_stat = stat;
	/* now insert the article */
	/* READ ARTICLE FROM STANDARD INPUT INTO TMP FILE */
	genhdr(&io, &h, anon);
	if (nfrom != 0 && getuid() == 1 && index(nfrom, '@'))
		strcpy(h.from, nfrom);
	lock(&io, 'n');
	i = chknote(&io, h.ident, &note2);
	if (i > 0) {
		if ((note2.n_msg.m_stat & ORPHND) == 0) {
			unlock(&io, 'n');
			finish(&io);
			exit(GOOD);
		}
		puthdr(&io, &note.n_msg, &h);
		pagein(&io, stdin, &note.n_msg.m_addr);	
		note2.n_msg = note.n_msg;
		note2.n_lmod = h.rectime;
		putnrec(&io, i, &note2);
		unlock(&io, 'n');
#ifdef MSGID_INDEX
		putmsgid(&io, i, 0, &note.n_msg);
#endif /* MSGID_INDEX */
		finish(&io);
		exit(GOOD);
	}
	if (re_seen) {
		strcpy(io.xstring, note.n_title);
		i = findtitle(&io, io.descr.d_nnote);
		if (i > 0)
			getnrec(&io, i, &note2);
	}
	if (re_seen == 0 || i <= 0) {
		puthdr(&io, &note.n_msg, &h);
		pagein(&io, stdin, &note.n_msg.m_addr);	
		i = putnote(&io, &note, NOPOLICY, ADDTIME);
	} else if (i > 0 && !chkresp(&io, h.ident, &note2, i)) {
		puthdr(&io, &note.n_msg, &h);
		pagein(&io, stdin, &note.n_msg.m_addr);	
		putresp(&io, i, &note2, &note.n_msg, ADDTIME);
	}
	unlock(&io, 'n');
	finish(&io);
	exit(GOOD);
}

/*
 * get the generic notes title
 */
char *
gettitle(s)
	char *s;
{
	register char *p;

	/*
	 * see if a followup; strip all "Re:"'s
	 */
	p = s;
	while (strncasecmp("Re:",p,3)==0) {
		p += 3;
		/* Skip Spaces */
		while (*p == ' ' || *p == '\t')
			p++;
		re_seen = 1;
	}
	return (p);
}

usage (invokedas)
char *invokedas;
{
    fprintf (stderr,
        "Usage: %s -n nfname -t title [-f from] [-d] [-a]\n",
	invokedas);
}
