/* $Header: dosystem.c,v 1.4 87/08/25 15:29:17 notes Exp $ */

/*
 * dosystem will execute a character string as a shell command
 * runs as the notes user
 */

#include "parms.h"
#include "structs.h"

/* VARARGS */
dosystem(arg0, arg1, arg2, arg3, arg4)
	char *arg0, *arg1, *arg2, *arg3, *arg4;
{
	register pid, rpid;
	int retcode;

	fflush(stdout);
	if ((pid = fork()) == 0) {
		closeRFA(); /* see below */
		setgid(notesgid);
		execlp(arg0, arg0, arg1, arg2, arg3, arg4);
		fprintf(stderr, "dosystem: execlp of \"%s\" failed\n", arg0);
		perror(arg0);
		_exit(1);
	}
	while ((rpid = wait(&retcode)) != pid && rpid != -1)
		continue;
	return(rpid!=-1 ? retcode>>8 : 1);
}

/*	While a user is reading notes over RFA he has to 
**	have the file access priveleges of the user "notes".
**	However, we don't want to give this access to 
**	any programs that the user might spawn off from his
**	notes session, so we put a call to the following
**	in the child process of any fork(). 
*/
closeRFA()
{
#ifdef RFA
	netunam (remote_netfile, "");
#endif RFA
}
