/* $Header: getpath.c,v 1.1 85/12/20 16:49:02 notes Exp $ */

#include "parms.h"
#include "structs.h"

/** strtok(), strcmp(), and strcpy() are documented in STRING(3C) in **/
/** BELL RELEASE 3.0 Unix User's Manual **/
extern char *strtok();

getpath(sysname, pathname, mapname) 
char *sysname, *pathname, *mapname;
{
	char buffer[PATHLEN];
	char *sname;
	FILE *mapfile;
	static char whitespace[] = " \t\n";

	if ((mapfile = fopen(mapname, "r")) == NULL) {
		/** cannot open file!!! **/
		return(-2);
	}

	while (fgets(buffer, sizeof buffer, mapfile) != NULL) {
		if (sname = strtok(buffer, whitespace)) {
#ifdef COSTS
		/** first string is costs - so get the next **/
		if (sname = strtok(NOSTR, whitespace)) {
#endif
			if (strcmp(sname, sysname) == 0) {
				if (sname = strtok(NOSTR, whitespace)) {
					strcpy(pathname, sname);
					fclose(mapfile);
					return(0);
				} else {
					/** input file format is bad **/
					continue;
				}
			}
		}
#ifdef COSTS
		}
#endif
		/** else - strange input line - so continue **/
	}

	/** If the loop terminates, the name was not found **/
	fclose(mapfile);
	return(-1);
}
