/* $Header: timein.c,v 1.2 86/03/05 13:20:36 notes Exp $ */

#include "parms.h"
#include "structs.h"
#include <time.h>

/*
 *	timein(line, atime) - grab a time from a coded line.
 *	makes sure that all the pieces of a time come in.
 */
timein(line, atime)
	char *line;
	time_t *atime;
{
	struct tm tm;
	int count;

	count = sscanf(line, "%d:%d:%d:%d:%d", &tm.tm_year, 
		&tm.tm_mon, &tm.tm_mday, &tm.tm_hour, &tm.tm_min);
	if (count == 5 && tm.tm_year >= 1970 && tm.tm_year <= 1999 &&
	    tm.tm_mon >= 1 && tm.tm_mon <= 12) {
		tm.tm_sec = 0;
		tm.tm_year -= 1900;
		tm.tm_mon -= 1;
		tm_to_time(&tm, atime);
	} else {
		log("timein: bad date read, set to now");
		time(atime);
	}
}
