#ifdef	RCSIDENT
static char rcsid[]="$Header: mkindex.c,v 1.2 87/02/05 19:53:51 notes Exp $";
#endif	RCSIDENT

/*
 *	mkindex - make a message-ID index from scratch
 */

#include "parms.h"
#include "structs.h"
#include <fcntl.h>

extern int   errno;
extern char *sys_errlist[];

int ignsigs = 0;

main(argc, argv)
char **argv;
{
	int i;
	struct nfile *np;
	struct io_f   io;
	char fn[BUFLEN];	/* filename for msg-ID database */
	char datfn[BUFLEN];	/* database.dat */
	char pagfn[BUFLEN];	/* database.pag */
	int  returnval = GOOD;	/* arg for exit() */
	DBM  *db;
	datum key;
	datum content;
	struct note_f note;
	struct resp_f rrec;
	int  notenum;
	int  respnum;
	int  rrecnum;
	int  roffset;

	initenv();

	if (argc == 1) {
	    usage(argv[0]);
	    exit (BAD);
	}

	/* MAYBE ALLOW DIRECTOR'S TOO? */
	if (globuid != notesuid) {
		fprintf(stderr, "Sorry, only notes 'owner' can rebuild the Message-ID index\n");
		exit(BAD);
	}


	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {

			case 'f': 		/* process a file */
				readrc(argv[++i]);
				break;

			default: 
				fprintf(stderr, "Bad switch: %c\n", argv[i][1]);
				usage(argv[0]);
				exit(BAD);
			}
		} else {
			expand(argv[i]);
		}
	}

	for (np = nfile; np; np = np->n_next) {
	  if (np->n_lookat == 0)
	    continue;
		
	  sprintf(fn, "%s/%s/%s", spooldir, mapnfname(np->n_name), INDEXM);

	  /* Create an empty index database */
	  db = dbm_open(fn, O_RDWR|O_CREAT|O_TRUNC, 0664)
	  x(db == NULL,
	    "mkindex: initial open of dbm database failed, db= \"%s\"", fn);

#ifdef notdef
	  /* Store a version number */
	  key.dptr = DB_VERS_KEY;
	  key.dptr = strlen(DB_VERS_KEY) + 1;
	  content.dptr = DB_VERSION;
	  content.size = strlen(DB_VERSION) + 1;
	  x(dbm_store(db, key, content) < 0,
	    "mkindex: dbm_store failed on %s, %s", key, content);
#endif /* notdef */

	  dbm_close(db);
	  
	  if (init(&io, np->n_name) < 0)
	    {
	      fprintf(stderr, "%s: cannot open notesfile \"%s\"\n",
		      argv[0], np->n_name);
	      exit(NONF);
	    }

	  /* We lock this so that we don't miss any articles that */
	  /* are added while we are scanning */
	  
	  lock(&io, 'n');		/* ENTER CRITICAL */
	  lock(&io, 'r');


	  for (notenum = 1 ; notenum <= io.descr.d_nnote ; notenum++) {
	    getnrec(&io, notenum, &note);
	    putmsgid(&io, notenum, 0, &note.n_msg);

	    /* This loop does zero iterations if note.n_resp == 0 */
	    for (respnum = 1 ; respnum <= note.n_nresp ; respnum++) {
	      if (lrsp(&io, notenum, respnum, &rrec, &roffset, &rrecnum) == -1)
	        break;			/* no such response */
	      putmsgid(&io, notenum, respnum, &rrec.r_msg[roffset]);
	    }
	  }

	  unlock(&io, 'r');
	  unlock(&io, 'n');		/* EXIT CRITICAL */
	  
	  finish(&io);
	}

	exit(returnval);
}

usage (invokedas)
char *invokedas;
{
	fprintf(stderr,
	    "Usage: %s [-f file] topic1 [topic2 ...]\n",
	    invokedas);
}
