/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/nfrcv.c,v 2.0 89/04/16 00:24:18 gore Exp $ */

/* 
 *	netrcv - load a notefile from the network
 *	accepts 2 parameters (1) the source system
 *			     (2) the notefile to load into
 *
 *	This program should be called only by the netload program
 *	or a suitably informed user/wizard
 *
 *	Original author:	Ray Essick	december 1981
 */

#include "parms.h"
#include "structs.h"

main(argc, argv)
char **argv;
{
    struct io_f io;
    char line[CMDLEN];
    time_t atime;
    int extensive = NODETAIL;
    int trust = NODETAIL;
    int did_ok;

    initenv();

    if (argc > 1 && strcmp(argv[1], "-e") == 0) {
	if (globuid != notesuid) {
	    printf("nfrcv: must be notes user to use -e.\n");
	    exit(BAD);
	}
	argc--; argv++;
	extensive = DETAIL;
    }
    if (argc > 1 && strcmp(argv[1], "-t") == 0) {
	if (globuid != notesuid) {
	    printf("nfrcv: must be notes user to use -t.\n");
	    exit(BAD);
	}
	argc--; argv++;
	extensive = DETAIL;
	trust = DETAIL;
    }
    if (argc != 3) {
	printf("Usage: nfrcv [-e] [-t] notefile fromsystem\n");
	exit(BAD);
    }

    time(&atime);

    if (init(&io, argv[1]) < 0) {

#ifdef AUTOCREATE
	/* try to create the notes file */
	sprintf(line, "%s/mknf", libdir);
	dosystem(line, "-on", argv[1], NOSTR);
	if (init(&io, argv[1]) < 0) {
	    sprintf(line, "nfrcv: no such notesfile: %s from %s\n",
		    argv[1], argv[2]);
	    nfcomment(NOSUCHWARN, line, "Failure", 0, 0);
	    exit(BAD);
	}

	sprintf(line, "nfrcv: created: %s, from %s\n", argv[1],argv[2]);
	nfcomment(NOSUCHWARN, line, line, 0, 0);
#else
	sprintf(line, "nfrcv: notesfile: %s, from %s\n", argv[1],argv[2]);
	nfcomment(NOSUCHWARN, line, "Failure", 0, 0);
	exit(BAD);
#endif
    }

    if ((io.descr.d_stat & NETWRKD) == 0) {
	printf("%s: %s is not a networked notefile\n", full_hostname, argv[1]);
	finish(&io);

	log("Non-networked notefile: %s sent from %s", argv[1], argv[2]);
	exit(NONF);
    }

    did_ok = loadem(&io, stdin, (trust == DETAIL) ? NOLOCKIT : LOCKIT,
		    argv[2], extensive, trust);

    log("%s: received from %s %d notes and %d responses", argv[1],
	argv[2], io.nnotrcvd, io.nrsprcvd);
    log("%s: dropped from %s %d notes and %d responses", argv[1],
	argv[2], io.nnotdrop, io.nrspdrop);

    lock(&io, 'n');

    getdscr(&io, &io.descr);
    io.descr.netwrkins++;		/* bump the count */
    putdscr(&io, &io.descr);

    unlock(&io, 'n');

    printf("%s: notefile: %s\tInserted: %d notes and %d responses from %s\n",
	   full_hostname,
	   argv[1], io.nnotrcvd, io.nrsprcvd, argv[2]);
    printf("%s: notefile: %s\tDropped: %d notes and %d responses from %s\n",
	   full_hostname,
	   argv[1], io.nnotdrop, io.nrspdrop, argv[2]);

    finish(&io);
    exit(did_ok);
}
