/* $Header: dump.c,v 1.4 86/06/17 15:25:07 notes Exp $ */

/*
 * Dump a notesfile.
 * This includes the access list, notes, and responses
 */

#include "parms.h"
#include "structs.h"

int permissions = 0;

main(argc, argv)
	char **argv;
{
	initenv();

	while (argc > 1 && argv[1][0] == '-') {
		switch (argv[1][1]) {
		case 'p':
			permissions++;
			break;
		}
		argc--, argv++;
	}
	while (--argc > 0)
		dump(*++argv);
}
	
dump(nfname)
char *nfname;
{
	struct io_f io;
	struct note_f note;
	int i;

	if (init(&io, nfname) < 0) {
		fprintf(stderr, "%s: can not open.\n", nfname);
		return(-1);
	}

	if ((allow(&io, DRCTOK) == 0) && (globuid != notesuid)) {
		closenf(&io);
		fprintf(stderr, "%s: must be director.\n", nfname);
		return(-1);
	}
/*
	lock(&io, 'n');
*/
	getdscr(&io, &io.descr);
	if (permissions)
		dmpperm(&io);
	for (i = 1; i <= io.descr.d_nnote; i++) {
		getnrec(&io, i, &note);
		if (note.n_stat & DELETED)
			continue;
		dmpnote(&io, &note, i, stdout, DETAIL);
		dmprall(&io, &note, i, stdout, DETAIL);
	}
/*
	unlock(&io, 'n');
*/
	finish(&io);
	return(0);
}

dmpperm(io)
	struct io_f *io;
{
	struct perm_f p;
	char fn[128];
	FILE *f;

	sprintf(fn, "%s/%s/%s", spooldir, mapnfname(io->nf), ACCESS);
	if ((f = fopen(fn, "r")) == NULL) {
		fprintf(stderr, "%s: no access file.\n", io->nf);
		return;
	}
	fputs("P:\n", stdout);
	while (fread((char *)&p, sizeof p, 1, f) == 1) {
		printf("%s:", p.name);
		if (p.ptype == PERMUSER)
			putchar('U');
		else if (p.ptype == PERMGROUP)
			putchar('G');
		else if (p.ptype == PERMSYSTEM)
			putchar('S');
		putchar(':');
		if (p.perms & DRCTOK)
			putchar('D');
		if (p.perms & READOK)
			putchar('R');
		if (p.perms & WRITOK)
			putchar('W');
		if (p.perms & RESPOK)
			putchar('A');
		putchar('\n');
	}
	fclose(f);
	putchar('\n');
}
