/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/structs.h,v 2.0 89/04/16 00:37:31 gore Exp $ */

/*	structure definitions for the notefile program */

#ifndef __STRUCTS__
#define __STRUCTS__

#include <stdio.h>
#include <setjmp.h>
#include <sys/types.h>
#ifdef MSGID_INDEX
#  include <ndbm.h>
#endif /* MSGID_INDEX */

#include "dumpmsg.h"

#ifdef	VFORK
#define	fork	vfork
#endif

#define NETCHRS	"!:.@^%"	/* Punct. chars used for various networks */
#define	PROTO	'A'
#define	FALSE	0
#define	TRUE	1
#define	NGDELIM	','

/* special notesfiles */
#define	CTRLMSG		"control"	/* notefile to put control msgs into */
#define	JUNK		"junk"		/* where to put junk messages */
#define	GRIPES		"nfgripes"	/* name of gripe notefile */
#define	NOSUCHWARN	"nfmaint"	/* "can't find" net nfs */

/* files in the users home directory */
#define	NOTESRC	 	".notesrc"	/* default subscription file */
#define	NOTESEQ	 	".nfseq"	/* default sequencer file */

/* files and directories in the notes libdir */
#define	CONFIGFILE 	"config"	/* configuration file */
#define	INVALID		"invalid"	/* file of invalid newsgroups */
#define	NEWSALIAS	"alias"		/* map incoming newsgroups */
#define	NETLOG		"net.log"	/* log file for network */
#define	SEQ		"SEQ"		/* next d_nfnum available */
#define	ACTIVE		"Active"	/* file for list of active groups */
#define	MAKEACTIVE	"mkactive"	/* script for making ACTIVE */
#define	MAKEINDEX	"mkindex"	/* builds Message-ID index */
#define	LOCKS		"locks"		/* lock directory */
#define	RMTDIR		"sys"		/* where sequencer files live */
#define	MODFILE		"moderators"	/* list of moderators */
  
/* help files */
#define	INDXHLP		"index.help"	/* name of index page help */
#define	RDMHLP		"read.help"	/* name of readem page help file */
#define	LIMHLP		"lim.help"	/* help for limited index */
#define	ACCHLP		"access.help"	/* for access editor */
#define	DIRHLP		"dir.help"	/* for director options */
#define	AVAILHLP	"avail.help"	/* list of public notefiles */

#define	AUTOSEQ  	"autoseq"	/* auto-sequencer link */
#define	ANONYMOUS	"Anonymous"	/* author name for anon submission */
#define	OLDSUFFIX	"- from a notesfile"	/* to catch nf-news-nf */
#define	NFSUFFIX	"- (nf)"		/* to catch nf-news-nf */

#define	SEQLOCK 	's'			/* lock flags */
#define	LOGLOCK		'l'

/* file names */
#define		INDEXM	"MSGID.INDEX"	/* index of msg-ID's of all articles */
#define		TEXT	"BODY.TEXT"	/* name of text file */
#define		INDEXN	"NOTE.INDEX"	/* master index */
#define		INDEXR	"RESP.INDEX"	/* response chains */
#define		ACCESS	"ACCESS.LIST"	/* access lists in here */
#define		STRPOOL	"STRING.POOL"	/* miscellaneous string pool */


/* sizes used in the notes database */
/* if you change any of these, you must dump and reload all notesfiles */
#define		RESPSZ	5		/* number responses/response record */
#define		TITLEN	128		/* note title length */
#define		NNLEN	128		/* Notesfile Name length */
#define		DMLEN	128		/* director message length */
#define		BUFLEN	128

/* these are used in the database, but can be increased as desired */
#define		NPERMS	35		/* max access list size */
#define		NUMGROUPS 5		/* max newsgroups we will post to */

/* sizes used only in code */
/* these may be modified without affecting the database format */
#define		LBUFLEN	1024
#define		PATHLEN	256
#define		NAMELEN	64
#define		NAMESZ	32		/* max number of characters in name */
#define		SYSSZ	32		/* max system name length */
#define		IDSZ	512		/* unique identifier string */
#define		WDLEN	255		/* longest file name length */
#define		CMDLEN  1024		/* command length */
#define		DATELEN	64		/* length of formatted date */
#define		ADDRLEN	256		/* longest mail address */

/* some other defines, also safe to change */
#define		NINDEX	18		/* how many notes on directory page */
#define		PAGESAV	120		/* display stack */
#define		NOTESUMASK	007

#define		NOSTR		(char *)0
#define		DAYSECS		(24L * 60L * 60L)

/* Flags for d_stat (in descriptor) */
#define		ANONOK		0001		/* permit anon notes */
#define		OPEN		0002		/* open for public */
#define		NFINVALID	0010		/* got bad copy */
#define		NETWRKD		0020		/* networking OK */
#define		MODERATED	0040		/* is a moderated group */
#define		ISARCH	   0400		/* is an archive (not used) */

/* Flags for m_stat (in msg struct) */
#define		FRMNEWS    01		/* non-nf article */
#define		DIRMES	   04		/* director msg on */
#define		DELETED	   010		/* is deleted */
#define		CONTINUED  040		/* was auto-split */
#define		WRITONLY   0100		/* writeonly access when written */
#define		ORPHND	   0200		/* foster parent */

/* change these only after modifying the table in access.c */
#define		READOK	01		/* allow user to read */
#define		WRITOK	02		/* allow user to write */
#define		DRCTOK	04		/* allow user to be director */
#define		RESPOK  010		/* ok to respond */
#define		DFLTPERMS (READOK|WRITOK|RESPOK) /* default permissions */
#define		DFLTPRMST "rwa"		/* same as above, as a string */

/* Flags for the linked list of notesfiles built by readrc() */
#define		NOSEQ		0	/* no sequencer */
#define		NORMSEQ		1	/* normal sequencer */
#define		EXTSEQ		2	/* enter anyway sequencer */
#define		INDXSEQ		3	/* index sequencer */
#define		UPDSEQ		6	/* update sequence info */
#define		TERSE		64 	/* modifier: use terse mode */

/* values returned to main program */
#define		QUITSEQ		-2	/* quit, update sequencer */
#define		QUITNOSEQ	-3	/* quit, no seq update */
#define		QUITFAST	-4	/* quit almost abort */
#define		QUITUPD  	-5      /* update seq and exit, RLS */
#define		QUITNEX		-6	/* no such notesfile */
#define		QUITBAD		-7	/* error opening notesfile */

/* exit values, returned with exit() */
#define		GOOD		0	/* good exit status */
#define		BAD		1	/* bad exit status */
#define		NONF		2	/* no notefile */
#define		BADFORMAT	3	/* bad incoming notes or news */

#define		POLICY		1	/* mnemonics */
#define		NOPOLICY	0	/* used in calls */
#define		LOCKIT		1	/* Do not change */
#define		NOLOCKIT	0
#define		ADDID		1
#define		NOADDID		0
#define		ADDTIME		1
#define		NOADDTIME	0
#define		DETAIL		1	/* dump extra info (nfdump/nfload) */
#define		NODETAIL	0	/* generic form (nfxmit/nfrcv)*/

/* Values used by mailit().  Specify a destination for the mail. */
#define		OTHERS		0	/* let the user choose */
#define		AUTHOR		1	/* to the author of displayed note */
#define		MODERATOR	2	/* to newsgroup moderator */

/*
 *	These defines are for the archiver. They are used for determining
 *	eligibility for archival along with the age of the note.
 *	DFLT means to use whatever value was supplied on the archive
 *	command line.  The others mean the notesfile is configured
 *	for a specific archival setup.
 */
#define		DIRDFLT		0			/* use cmd line */
#define		DIRNOCARE	1			/* don't check dir */
#define		DIRON		2			/* only if dir on */
#define		DIROFF		3			/* only if dir off */

#define		KEEPDFLT	0			/* use cmd line */
#define		KEEPNO		1			/* delete 'em */
#define		KEEPYES		2			/* archive 'em */

struct txthead_f {			/* way note text stored */
	short	note_no;		/* to which note this text belongs
					   (0=policy) */
	short	resp_no;		/* to which response this text belongs
					   (0=main note) */
	/* both for debugging */
	long	textlen;		/* how long the text is */
};

struct daddr_f {			/* save a disk address */
	long	addr;			/* for lseeks */
};

struct msg_f {
	/* parsed header fields */
	short	m_from;			/* author name */
	short	m_artid;		/* article id */
	short	m_ngroup;		/* newsgroup */
	short	m_path;			/* article path */
	short	m_org;			/* author organization */
	short	m_misc;			/* miscellaneous */
	short	m_ctlmsg;		/* for control messages */
	short	m_replyto;		/* preferred address for reply */
	short	m_spare1;		/* for expansion without upsetting */
	short	m_spare2;		/*   the database format */
	struct	daddr_f m_head;		/* location of article header */
	struct	daddr_f m_addr;		/* location of article text */
	time_t	m_subtime;		/* submitted time (when posted) */
	time_t	m_rcvtime;		/* received time */
	int	m_stat;			/* director? */
};

struct resp_f {				/* for each response: */
	struct	msg_f r_msg[RESPSZ];
	int	r_next;			/* index of next response_ind */
};

struct note_f {				/* standard note structure: */
	struct	msg_f n_msg;
#define	n_stat	n_msg.m_stat
	short	n_nresp;		/* number of responses */
	char	n_title[TITLEN];	/* title of note */
	time_t	n_lmod;			/* date of last mod */
	int	n_rindx;		/* first set of responses lies */
};

typedef short string_length;		/* for each string in string.pool */

#define D_FILLER 32			/* bytes for future use */
struct descr_f {			/* for the notesfile: */
        long    d_format;		/* nf's format */
	char	d_title[NNLEN];		/* name of the notesfile */
	char	d_drmes[DMLEN];		/* director message */
	short	d_plcy;			/* ==0 if no message */
	time_t	d_lastm;		/* last modified time */
	short	d_stat;			/* open/closed/etc */
	short	d_nnote;		/* how many notes in file */
	int	d_id;			/* unique id counter */
	time_t	d_lstxmit;		/* last network transmit */
	time_t	d_created;		/* creation date */
	time_t	d_lastuse;		/* last day used */
	long	d_daysused;		/* count those days */
	long	d_rspwrit;		/* number of responses ever written */
	long	d_notwrit;		/* number of notes ever written */
	long	entries;  		/* number of entries into the nf */
	long	walltime;		/* man-seconds (?) spent in notefile */
	long	d_rspread;		/* number of responses read */
	long	d_notread;		/* and number of notes */
	long	d_rsprcvd;		/* network in stats */
	long	d_notrcvd;
	long	d_rspxmit;		/* network out stats */
	long	d_notxmit;
	long	d_notdrop;		/* duplicate notes recieved */
	long	d_rspdrop;		/* and dropped on ground */
	long	d_orphans;		/* orphaned responses */
	long	netwrkouts;		/* number of times networked out */
	long	netwrkins;		/* and number of networked in */
	short	d_nfnum;		/* unique to this notesfile */
	long	d_archtime;		/* archive after X days */
	long	d_workset;		/* working set size */
	long	d_dmesgstat;		/* use dirmsg for archive */
	long	d_archkeep;		/* keep/delete */
	char	d_filler[D_FILLER];	/* bytes for future use ... */
};

struct io_f {				/* master i/o form */
#ifdef MSGID_INDEX
	DBM	*msgindexp;		/* message-ID index */
#endif /* MSGID_INDEX */
	FILE	*fidtxt;		/* text */
	int	fidndx;			/* note.indx */
	int	fidrdx;			/* resp.indx */
	/* this notefile's descriptor, updated by critical sections */
	struct	descr_f descr;
	char	nf[NNLEN];		/* which notefile he is in */
	char	*str_pool_fn;		/* name of the string.pool file */
	char	xstring[TITLEN];	/* search string */
	char	xauth[BUFLEN];		/* author search name */
	time_t	stime;			/* read notes/resp after this time */
	short	access;			/* what sort of access user has */
	int	nrspwrit;		/* num of resp's written this entry */
	int	nnotwrit;		/* num of notes written */
	long	entered;		/* when started, to figure time in */
	int	nrspread;		/* how many responses he read */
	int	nnotread;		/* how many notes he read */
	/* num read may be tough */
	int	nnotxmit;		/* network out stats */
	int	nrspxmit;
	int	nnotrcvd;		/* network in stats */
	int	nrsprcvd;
	int	nnotdrop;		/* duplicates rom the network */
	int	nrspdrop;
	int	norphans;		/* orphaned responses */
};

/* parsed author name */
struct auth_f {
	char	*a_name;
	char	*a_sys;		/* includes the domain */
	char	*a_comment;
};

/* structure used in newsgroup expansion and sequencing */
struct nfile {
	char	*n_name;
	char	n_lookat;
	char	n_concise;
	char	n_jumpxpost;
	dumpfmt_t n_dumpfmt;
	char	n_seqtyp;
	time_t	n_when;
	struct	nfile *n_next;
};

/* some functions, chkref() for example, need to return a note/resp pair */
struct number_f {
	long	note;
	long	resp;
};

extern int verbose_mode;	/* issue verbose messages? */
extern int uucp_mailer;		/* use path rather that @ addresses */
extern int group_timeout;	/* how long before we delete a notesfile? */
extern int manual_mod_change;	/* do newgroup ctl msgs change moderation */
extern int manual_rmgroup;	/* are rmgroup ctl messages auto or manual */
extern char this_system[];	/* points at system name */
extern char myorg[];		/* points at organization name */
extern char libdir[];		/* lib directory, set to "notes" home dir */
extern char spooldir[];		/* points at spool directory name */
extern char archdir[];		/* points at archive directory name */
extern char mydomain[];		/* points at my domain name */
extern char prompt_str[];	/* prompt to use */
extern char remote_netfile[];	/* name of network special file for RFA */
extern char pager[];
extern char shell[];
extern char editor[];
extern char mailposter[];
extern char writeprog[];
extern char full_hostname[];
extern char hostname_in_path[];
extern char replyto_hostname[];
extern char *replyto_address;
extern char default_subm_addr[];
extern char address_canonizer[];
extern char *myhome;
extern char *myterm;
extern int  intflag;		/* flag DEL's */

#ifdef __STDC__
#ifdef BSD4_2
extern int	sprintf(char*, const char*, ...);
#else
extern char	*sprintf(char*, const char*, ...);
#endif
extern char	*getenv();
extern char	*index();
extern char	*rindex();
extern char	*malloc();
extern char	*strtok();
extern long	lseek();
extern time_t	time();
#else /*!__STDC__*/
#ifdef BSD4_2
extern int	sprintf();
#else
extern char	*sprintf();
#endif
extern char	*getenv();
extern char	*index();
extern char	*rindex();
extern char	*malloc();
extern char	*strtok();
extern long	lseek();
extern time_t	time();
#endif /*!__STDC__*/

#ifdef __STDC__
char	*strsave(char*);	/* satisfy lint (notes functions) */
char	*sukline(FILE*, char*);
struct  number_f  chkref(struct io_f*, char*, struct note_f*);
struct	nfile     *getnfile(char*);
char	*mapnfname(char*);
#else /*!__STDC__*/
char	*strsave();		/* satisfy lint (notes functions) */
char	*sukline();
struct  number_f  chkref();
struct	nfile     *getnfile();
char	*mapnfname();
#endif /*!__STDC__*/

extern int  globuid;		/* point at the true uid */
extern int  globgid;		/* point at the true gid */
extern int  notesuid;		/* dynamic notes user id */
extern int  notesgid;		/* dynamic notes group id */
extern int  nrows, ncols;	/* screen size */

extern char *notesrc;		/* notesrc file name, RLS */
extern int  nindex;		/* number of index lines, RLS */
extern struct nfile *nfile;

extern int ignsigs;		/* ignore signals */
extern int contsigs;		/* continue after signals instead of longjmp */
extern int replot;
extern int msk;
extern int terse;
extern char pending;
extern int concise_quotes;	/* skip hostname and tod when quoting notes */
extern int jump_over_xposts;	/* skip cross-posted notes already read */
extern dumpfmt_t dmp_format;	/* format of dumping a message to file */
extern int verbose_log;

struct notesenv {
	jmp_buf	n_env;
};

extern struct notesenv curenv;
#define	jenv	curenv.n_env

#endif __STRUCTS__
