/************************************************************************
*                                                                       *
*       Adding an X-Window interface to SMART --- smart_xmain_ui.c      *
*                                                                       *
*                                                                       *
*    by: Victuria Chiu, senior in CS from Univ. of Cal. at Berkeley,    *
*                e-mail: victoria@csr.lbl.gov                           *
*                                                                       *
*        Tong Li, graduate student in CS from Oregon State University,  *
*                e-mail: lit@mist.cs.orst.edu                           *
*                                                                       *
*    at Lawrence berkeley Laboratory, Summer 1991                       *
*                                                                       *
************************************************************************/
/*
 * smart_xmain_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `smart_xmain.G'.
 * THIS FILE HAS BEEN ALTERED BY HAND. Therefore gxv is disabled to avoid
 * overwriting this file.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "smart_xmain_ui.h"
#include <gcm.h>
#include "xfunctions.h"

/*
 * Create object `quit_menu' in the specified instance.

 */
Xv_opaque
smart_xmain_quit_menu_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern Menu_item	x_quit();
	extern Menu_item	x_xit();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "quit",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_quit,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "xit",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_xit,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, (Xv_opaque) ip[0], "Quit",
		NULL);
	return obj;
}


/*
 * Create object `advanced_menu' in the specified instance.

 */
Xv_opaque
smart_xmain_advanced_menu_create(ip, owner)
	caddr_t		*ip;
	Xv_opaque	owner;
{
	extern Menu_item	x_raw_doc();
	extern Menu_item	x_top_ranked();
	extern Menu_item	x_location();
	extern Menu_item	x_spec_file();
	extern Menu_item	x_dtext();
	extern Menu_item	x_dvec();
	extern Menu_item	x_drun();
	extern Menu_item	x_dsim();
	extern Menu_item	x_dmatch();
	extern Menu_item	x_qtext();
	extern Menu_item	x_qvec();
	extern Menu_item	x_qsim();
	extern Menu_item	x_qmatch();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Raw_doc",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_raw_doc,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Top_ranked",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_top_ranked,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Location",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_location,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Spec_file",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_spec_file,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Dtext <did>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_dtext,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Dvec <did>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_dvec,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Drun <did>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_drun,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Dsim <did1> <did2>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_dsim,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Dmatch <did1> <did2>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_dmatch,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Qtext",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_qtext,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Qvec",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_qvec,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Qsim <did>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_qsim,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Qmatch <did>",
                        MENU_COLOR, gcm_color_index("Firebrick"),
			MENU_GEN_PROC, x_qmatch,
			NULL,
		MENU_DEFAULT, 12,
		MENU_GEN_PIN_WINDOW, (Xv_opaque) ip[0], "advanced functions",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `basewindow'.
 */
smart_xmain_basewindow_objects *
smart_xmain_basewindow_objects_initialize(ip, owner)
	smart_xmain_basewindow_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (smart_xmain_basewindow_objects *) calloc(1, sizeof (smart_xmain_basewindow_objects))))
		return (smart_xmain_basewindow_objects *) NULL;
	if (!ip->basewindow)
		ip->basewindow = smart_xmain_basewindow_basewindow_create(ip, owner);
	if (!ip->main_control)
		ip->main_control = smart_xmain_basewindow_main_control_create(ip, ip->basewindow);
	if (!ip->retrieve)
		ip->retrieve = smart_xmain_basewindow_retrieve_create(ip, ip->main_control);
	if (!ip->more)
		ip->more = smart_xmain_basewindow_more_create(ip, ip->main_control);
	if (!ip->keywords)
		ip->keywords = smart_xmain_basewindow_keywords_create(ip, ip->main_control);
	if (!ip->advanced)
		ip->advanced = smart_xmain_basewindow_advanced_create(ip, ip->main_control);
	if (!ip->quit)
		ip->quit = smart_xmain_basewindow_quit_create(ip, ip->main_control);
	if (!ip->feedback)
		ip->feedback = smart_xmain_basewindow_feedback_create(ip, ip->main_control);
	if (!ip->next)
		ip->next = smart_xmain_basewindow_next_create(ip, ip->main_control);
	if (!ip->clear)
		ip->clear = smart_xmain_basewindow_clear_create(ip, ip->main_control);
	if (!ip->help)
		ip->help = smart_xmain_basewindow_help_create(ip, ip->main_control);
	if (!ip->save)
		ip->save = smart_xmain_basewindow_save_create(ip, ip->main_control);
	if (!ip->general_msg)
		ip->general_msg = smart_xmain_basewindow_general_msg_create(ip, ip->main_control);
	if (!ip->user_textpane)
		ip->user_textpane = smart_xmain_basewindow_user_textpane_create(ip, ip->basewindow);
	if (!ip->main_control2)
		ip->main_control2 = smart_xmain_basewindow_main_control2_create(ip, ip->basewindow);
	if (!ip->title_list)
		ip->title_list = smart_xmain_basewindow_title_list_create(ip, ip->main_control2);
	return ip;
}

/*
 * Create object `basewindow' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_basewindow_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 643,
		XV_HEIGHT, 683,
		XV_LABEL, "Smart Text Retrieval System",
		FRAME_CLOSED, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		NULL);
        gcm_initialize_colors(obj, "Blue", "Black");
	return obj;
}

/*
 * Create object `main_control' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_main_control_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, 640,
		XV_HEIGHT, 96,
		WIN_BORDER, FALSE,
		NULL);
        gcm_initialize_colors(obj, "Light Blue", "Medium Blue");
	return obj;
}

/*
 * Create object `retrieve' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_retrieve_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_retrieve();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:retrieve",
		XV_X, 32,
		XV_Y, 16,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, " Retrieve",
                PANEL_INACTIVE, TRUE,
		PANEL_EVENT_PROC, x_retrieve,
		NULL);
	return obj;
}

/*
 * Create object `more' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_more_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_more_documents();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:more",
		XV_X, 144,
		XV_Y, 16,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   More",
                PANEL_INACTIVE, TRUE,
		PANEL_EVENT_PROC, x_more_documents,
		NULL);
	return obj;
}

/*
 * Create object `keywords' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_keywords_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_keywords();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:keywords",
		XV_X, 256,
		XV_Y, 16,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "Keywords",
		PANEL_NOTIFY_PROC, x_keywords,
		NULL);
	return obj;
}

/*
 * Create object `advanced' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_advanced_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:advanced",
		XV_X, 371,
		XV_Y, 16,
		PANEL_LABEL_WIDTH, 85,
		XV_WIDTH, 85,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "Advanced",
                PANEL_INACTIVE, TRUE,
		PANEL_ITEM_MENU, smart_xmain_advanced_menu_create((caddr_t *) ip, NULL),
		NULL);
	return obj;
}

/*
 * Create object `quit' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_quit_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:quit",
		XV_X, 496,
		XV_Y, 16,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Quit",
		PANEL_ITEM_MENU, 
			smart_xmain_quit_menu_create((caddr_t *) ip, NULL),
		NULL);
	return obj;
}

/*
 * Create object `feedback' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_feedback_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_feedback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:feedback",
		XV_X, 32,
		XV_Y, 48,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "Feedback",
                PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, x_feedback,
		NULL);
	return obj;
}

/*
 * Create object `next' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_next_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_next_document();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:next",
		XV_X, 144,
		XV_Y, 48,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Next",
                PANEL_INACTIVE, TRUE,
		PANEL_EVENT_PROC, x_next_document,
		NULL);
	return obj;
}

/*
 * Create object `clear' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_clear_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		clear_usertext();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:clear",
		XV_X, 256,
		XV_Y, 48,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Clear",
		PANEL_EVENT_PROC, clear_usertext,
		NULL);
	return obj;
}

/*
 * Create object `help' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_help_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_help();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:help",
		XV_X, 371,
		XV_Y, 48,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Help",
		PANEL_NOTIFY_PROC, x_help,
		NULL);
	return obj;
}

/*
 * Create object `save' in the specified instance.
 */

Xv_opaque
smart_xmain_basewindow_save_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void	x_save();
	Xv_opaque	obj;

	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:save",
		XV_X, 496,
		XV_Y, 48,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
                PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Save",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, x_save,
		NULL);
	return obj;
}


/*
 * Create object `general_msg' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_general_msg_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "smart_xmain:general_msg",
		XV_X, 8,
		XV_Y, 72,
		XV_WIDTH, 465,
		XV_HEIGHT, 13,
                PANEL_ITEM_COLOR, gcm_color_index("Blue"),
		PANEL_LABEL_STRING, "Enter natural language query below and press the Retrieve Button.  ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `user_textpane' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_user_textpane_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Notify_value	x_hilite_button();
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 92,
		XV_WIDTH, 640,
		XV_HEIGHT, 100,
		OPENWIN_SHOW_BORDERS, TRUE,
		NULL);
        gcm_initialize_colors(obj, "Light Blue", "Black");
	xv_set(textsw_first(obj), WIN_CONSUME_EVENTS,
		NULL, NULL);
	notify_interpose_event_func(textsw_first(obj),
		(Notify_func) x_hilite_button, NOTIFY_SAFE);
	return obj;
}

/*
 * Create object `main_control2' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_main_control2_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 195,
		XV_WIDTH, 640,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
        gcm_initialize_colors(obj, "Light Blue", "Medium Blue");
	return obj;
}

/*
 * Create object `title_list' in the specified instance.

 */
Xv_opaque
smart_xmain_basewindow_title_list_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		show_document();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 5,
		PANEL_LIST_WIDTH, 620,
		XV_HEIGHT, 469,
		PANEL_LABEL_STRING, "  Num      Sim      Title",
                PANEL_ITEM_COLOR, gcm_color_index("Blue"),
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_LIST_DISPLAY_ROWS, 24,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, FALSE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, show_document,
		NULL);

	return obj;
}

