/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.8
   Fri Feb  1 1991

   jonathan@Think.COM

*/

#ifndef _H_QUESTION
#define _H_QUESTION

#include "../ir/ui.h"

#define MAX_MESSAGE_LEN BUFSZ

#define QUESTION_FILE_VERSION 1

#define CHARS_PER_PAGE 2000

typedef struct question{
  char *type;
  char name[STRINGSIZE];
  char keywords[5000];
  short version;
  short view;
  int numsources;
  SourceList Sources;
  int CurrentSource;
  int numdocs;
  DocList RelevantDocuments;
  int CurrentRelDoc;
  int numresdocs;
  DocList ResultDocuments;
  int CurrentResDoc;
  char request_message[MAX_MESSAGE_LEN]; /* arbitrary message limit */
  char response_message[MAX_MESSAGE_LEN]; /* arbitrary message limit */
  SearchResponseAPDU  *query_response;
  SearchResponseAPDU  *retrieval_response;
  WAISSearchResponse  *query_info;
  Boolean modified;
} _Question, *Question;

/* function definitions */

Question findQuestionWindow();
char **buildQuestionItemList();
DocList build_response_list();
void SearchWais();
void ViewWaisDocument();
void RetrieveWaisDocument();

#endif
