/*		Manage different file formats			HTFormat.c
**		=============================
**
** Bugs:
**	Not reentrant.
*/

#include "HTUtils.h"
#include "tcp.h"
#include "HTFormat.h"

#include "HTML.h"
#include "HText.h"

extern HTStyleSheet * styleSheet;

/*	File buffering
**	--------------
**
**	The input file is read using the macro which can read from
**	a socket or a file.
**	The input buffer size, if large will give greater efficiency and
**	release the server faster, and if small will save space on PCs etc.
*/
#define INPUT_BUFFER_SIZE 4096		/* Tradeoff */
PRIVATE char input_buffer[INPUT_BUFFER_SIZE];
PRIVATE char * input_pointer;
PRIVATE char * input_limit;
PRIVATE int input_file_number;


/*	Set up the buffering
*/
PRIVATE void clear_input_buffer ARGS1(int file_number)
{
    input_file_number = file_number;
    input_pointer = input_limit = input_buffer;
}


PRIVATE char next_char NOARGS
{
    if (input_pointer >= input_limit) {
        int status = NETREAD(
		input_file_number, input_buffer, INPUT_BUFFER_SIZE);
	if (status <= 0) {
	    if (status == 0) return (char)EOF;
	    fprintf(stderr, "HTBrowse: File read error %d\n", status);
	}
	input_pointer = input_buffer;
	input_limit = input_buffer + status;
    }
    return *input_pointer++;
}


/*	Parse a file given format and file number
**	------------
*/
PUBLIC void HTParseFormat ARGS3(
	HTFormat 	format,
	HTParentAnchor * anchor,
	int 		file_number)
{
/*	Parse the file
*/
    clear_input_buffer(file_number);

    switch (format) {

    case WWW_HTML:		/* Parse HTML */
      {
        HTML_begin(anchor);
	SGML_begin(&HTML_dtd);
	for(;;) {
	    char character;
	    character = next_char();
	    if (character == (char)EOF) break;
    
	    SGML_character(&HTML_dtd, character);           
         }
	SGML_end(&HTML_dtd);
      }
	break;

    default :			/* unknown format -- Parse plain text */
      {
        HText * text = HText_new(anchor);
	HText_setStyle(text, HTStyleNamed(styleSheet, "Example"));
	HText_beginAppend(text);
	for(;;) {
	    char character;
	    character = next_char();
	    if (character == (char)EOF) break;
	    HText_appendCharacter(text, character);           
	}
        HText_endAppend(text);
      }
	break;
	
    } /* end of switch (format) */
    
}
