//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view for any URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		04-06-93	created
#include"turlview.h"
#include"trace.h"
#include<string.h>

void TURLView::isImage(const char *cp_imagefile)	{
//	Purpose:	Inform the view that there is an image and not any
//			displayable text.  We will save the image name and
//			displaying of the image will be handled in the
//			constructor.
//	Arguments:	cp_imagefile	The path of the file containing the
//					image to display.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Really does noting but save the name of the image by
//		allocation.  Other code will free the name once we are done
//		with it.
//	Revision History:
//		04-06-93	created

	//	Just copy the name.
	cp_imagename = new char[strlen(cp_imagefile) + 1];
	strcpy(cp_imagename, cp_imagefile);
#ifndef RELEASE
	trace("Image file " << cp_imagename << " registered for display.");
#endif // RELEASE
}