#!/usr/local/ls6/perl/bin/perl
#                              -*- Mode: Perl -*- 
# search-index.pl -- 
# ITIID           : $ITI$ $Header $__Header$
# Author          : Ulrich Pfeifer
# Created On      : Tue Feb 15 11:57:03 1994
# Last Modified By: Ulrich Pfeifer
# Last Modified On: Fri Jun 24 19:22:58 1994
# Update Count    : 383
# Status          : Unknown, Use with caution!

require 'getopts.pl' || die "Usage: $0 [-d]\n";
&Getopts('dt');

#-----------------------------------------------------------------
# Main dispatcher customize to your needs
# $path should be $ENV{'PATH_INFO'}
# $query $ENV{'QUERY_STRING'}
#-----------------------------------------------------------------
sub do_request {
    local($path, $query) = @_;
    local(%table, $tquery,@datbs);
    local($perror);

    &log("%d %s@%s, %s",$$, $ENV{'REMOTE_USER'}, 
         $ENV{'REMOTE_HOST'}, &decode("$path?$query"));
    
    %table = &parse_query_string($query);
    &do_sorry,die if $errno;

    if ($table{$dmpenv_field} =~ /yes/i) {
        delete($table{$dmpenv_field});
        delete($table{$debug_field});
        ($tquery,@datbs) = &translate_query1(%table);
        &dumpenv($query,$tquery,@databases);
        exit;
    } else {
        delete($table{$dmpenv_field});
    }
    if (defined($table{$maxhits_field})) {
        $WAISmaxdoc = $table{$maxhits_field} if $table{$maxhits_field} > 0;
        delete($table{$maxhits_field});
    }
    if (defined($table{$convert_field})) {
        $convert = $table{$convert_field};
        delete($table{$convert_field});
    }
    if (defined($table{$tie_field})) {
        $tie = $table{$tie_field};
	if ($tie =~ /und/ || $tie =~ /and/) {
	    $tie = "and";
	}
	else {
	    $tie = "";
	}
        delete($table{$tie_field});
    }
    if (defined($table{$directget_field})) {
        $directget = $table{$directget_field} if $table{$directget_field} > 0;
        delete($table{$directget_field});
    }
    if ($table{$debug_field} =~ /on/i) {
        $debugging = 1;
        delete($table{$debug_field});
        &print_header("$program Debug");
        print "<PRE>\n";
    } else {
        delete($table{$debug_field});
    }
    if (defined($table{'waisdoc'})) {
        delete($table{'waisdoc'});
        $query = "waisdoc=1&".&retranslate_query(%table);
        &dprint("%s getting doc\n", $query);
        &get_text($query);                                  # in wais.pl
    } else {
        ($tquery,@datbs) = &translate_query1(%table);
        &do_sorry,die if $errno;
        if ($#datbs<$[) {                                   # no database given
            # take the last path argument
            ($datbs = $path) =~ s:^.*/::;
            $datbs =~ s:.html$::;
            $datbs = "INFO" if $datbs eq "$program";
            if ($redirect) {                                # default: single wais
                &do_wais($tquery,$datbs);                   # redirection
            } else {
                $server = $location{$datbs} || $location{'default'};
                &do_multiple($tquery,("$server/$datbs"));   # connect wais server
            }
        } elsif ($#datbs>$[){                               # >1 databases given
            &do_multiple($tquery,@datbs);
        } else {                                            # 1 database given
            &dprint("database=%s\n", $datbs[$[]);
            if ($redirect) {                                # default: single wais
                &do_wais($tquery,$datbs[$[]);               # redirection
            } else {
                $server = $location{$datbs} || $location{'default'};
                &do_multiple($tquery,@datbs);               # connect wais server
            }
        }
    }
}

sub print_header {
    local($title) = @_;
    
    return if $opt_t;
    print <<"EOH"
Content-Type: text/html

<HTML>
<HEAD>
<TITLE>$title</TITLE>
</HEAD>
<BODY>
<a HREF=\"http:$docdir/$program.html\"><IMG SRC=\"$docdir/$program-small.gif\"></a>
<p>
EOH
    ;
}

sub print_footer {
    return if $opt_t;
    print <<"EOC"
<HR>
Script $program $revision written by <a HREF=\"http://ls6-www.informatik.uni-dortmund.de/WhoIsWhoAtLS6.html#Pfeifer\">Ulrich Pfeifer</a>.

<a HREF=\"ftp://ls6-www.informatik.uni-dortmund.de/pub/www/SFgate-$revision.tar.gz\">Source</a> is available.
</BODY></HTML>
EOC
    ;
    0;
}

# Perload ON :


sub do_wais {
    local($tquery,$datbs) = @_;
    local($location,$query);
    
    $location = $location{$datbs} || $location{'default'};
    $query = &encode($tquery);

    print <<"EOL"
Location: $location/$datbs?$query

EOL
    ;
}

sub dumpenv {
    local($query,$tquery,@databases) = @_;

    for (keys %ENV) {
        $ENV .= "$_=$ENV{$_}<p>";
    }
    &print_header("$program Dump Environement");
    print <<"EndoDebug"
<h1>Debug</h1>
ARGV[0]=$ARGV[0]<p>
ARGV[1]=$ARGV[1]<p>
PATH_INFO=$ENV{'PATH_INFO'}<p>
GATEWAY_INTERFACE=$ENV{'GATEWAY_INTERFACE'}<p>
query=$query<p>
translated query=$tquery<p>
databases=@databases<p>
query=$query<p>
QUERY_STRING=$ENV{'QUERY_STRING'}<p>
ENV = $ENV
EndoDebug
    ;
    &print_footer;
}

sub do_sorry {
    &print_header("Syntax error in query");
    print <<"EndoSorry"
<h1>Syntax error in query</h1>
Sorry! can\'t parse your query.

$perror

EndoSorry
;
    &print_footer;
    &log("$$ Error: $perror");
}

sub do_multiple {
    local($query,@databases) = @_;

    select(STDERR); $| = 1;                            # make unbuffered
    select(STDOUT); $| = 1;                            # make unbuffered

    #require 'waisserver.pl';
    &do_waisq($query, @databases);        # '
}

# insert query.pl
# insert waisutil.pl
# insert waisclient.pl

# call the dispatcher
($me = $0) =~ s:.*/::;

dump START if $opt_d;
START:
    chop($hostname = `hostname`);
    {
        if ($me =~ /$program/) {
            $path = $ENV{'PATH_INFO'};
            if ($ENV{'REQUEST_METHOD'} =~ /GET/) {
                $query=$ENV{'QUERY_STRING'};
            } else {
                $query=<STDIN>;
            }
            eval "\&do_request(\"$path\",\"$query\");";
            if ($@) {
                &log("request failed: %s", $@);
                &print_header("$me terminated");
                print <<"EOF"
<h1>$program terminated</h1>

The script terminated with message<p>

<b>$@</b>

Please contact the webmaster.
EOF
;
                &print_footer;
            } 
        } else {
            &print_header("$me terminated");
            print <<"EOF"
<h1>Strange Error</h1>

\"$me\" is not \"$program\"

Who called me then ?

Please contact the webmaster.
EOF
    ;
            &print_footer;
        }
    }

exit(0);

&do_request; # make perl -w happy
