/* nblp.c Version 0. 4 Feb 1992 */
/* Steven Bjork, bjork@telebit.com. */

/* Driver for printer hung off a NetBlazer. */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "nblp.h"

main(argc, argv)
int argc;
char *argv[];
{
  int sockfd, servlen;
  struct sockaddr_un serv_addr;
  char *pname;
  static char xudsname[UDSMAX + 1];

  pname = argv[0];

/* Build our socket name string. */
  strcpy(xudsname, XTFSNAME);
  strcat(xudsname, pname);

/* Build name into socket structure. */
  bzero((char *) &serv_addr, sizeof(serv_addr));
  serv_addr.sun_family = AF_UNIX;
  strcpy(serv_addr.sun_path, xudsname);
  servlen = strlen(serv_addr.sun_path) + sizeof(serv_addr.sun_family);

/* Open the socket we've defined. "/tmp/.nblpt10" for example... */
  if ( (sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0 ) {
    fprintf(stderr, "%s: Stream socket open failure.\r\n", pname);
    exit(1);
  }

/* Try to get there from here. */
  if (connect(sockfd, (struct sockaddr *) &serv_addr, servlen) < 0 ) {
    fprintf(stderr, "%s: Unix domain socket connect failed.\r\n", pname);
    exit(1);
  }

/* Start shoveling the bits. The unix lpr feeds us via stdin. */
  stdin2sock(stdin, sockfd);

  close(sockfd);
  exit(0);
}

stdin2sock(fp, sockfd)

register FILE *fp;
register int sockfd;

{
  int n;
  char *pname;
  char sendline[MAXLINE], recvline[MAXLINE + 3];
  while (fgets(sendline, MAXLINE, fp) != NULL) {
    n = strlen(sendline);
    if (writen(sockfd, sendline, n) != n) {
      fprintf(stderr, "%s: write error on socket.\r\n", pname);
      exit(1);
    }
    if (ferror(fp)) {
      fprintf(stderr, "%s: file read error.\r\n", pname);
      exit(1);
    }
  }
}

writen(fd, ptr, nbytes)
register int fd;
register char *ptr;
register int nbytes;

{
  int nleft, nwritten;
  nleft = nbytes;
  while (nleft > 0) {
    nwritten = write(fd, ptr, nleft);
    if (nwritten <= 0)
      return(nwritten);
    nleft -= nwritten;
    ptr += nwritten;
  }
  return(nbytes - nleft);
}
