/*************************************************************************
**
** agent.c - creates a linked list of all the possible agents that might
**		be invoked.  The code is used in both the text server
**		and the DICE visual interface.
**
*************************************************************************/

/*
 * $Log: agents.c,v $
 * Revision 1.1  1991/10/11  23:15:54  jefft
 * Initial revision
 *
 */

#include	<stdio.h>
#include	<string.h>

#include	"agents.h"


#define         NEW(type, count)        (type *)malloc(sizeof (type) * count)


static AGENT	*listhead = NULL;



AGENT *findAgent(alias)
  char	*alias;
{
  register AGENT	*ptr = listhead;

  while (ptr != NULL)
    if (!strcmp(ptr->alias, alias))
      break;
    else
      ptr = ptr->next;

  return ptr;
}


void addAgent(alias, inports, outports, path, args)
  char  *alias, *path, *args;
  char  **inports, **outports;
{
  register AGENT        *ptr;


  ptr = NEW(AGENT, 1);
  if (ptr == NULL)  {
    fprintf(stderr, "Error: out of memory!\n");
    exit(-1);
    }

  ptr->alias = alias;
  ptr->path = path;
  ptr->args = args;

  ptr->pixmap = NULL;

  ptr->inports = inports;
  ptr->outports = outports;

  ptr->next = listhead;
  listhead = ptr;
}
