/*************************************************************
**  
**  Program to build an SDS.  User gives size of image, whether
**  or not there should be a scale, whether the scales are
**  uniform or not, and max and min values.
**
**  See the file generate.c for details of what the array looks like.
**
**  Other modules:  calls generate(), which is in file generate.c
**
**  Input file:  none
**  Output file: name given by user on command line
**
**************************************************************/


#include <stdio.h>
#include <math.h>
#include "df.h"
#define TRUE    1
#define FALSE   0
char *malloc();

main(argc,argv)
int argc;
char *argv[];
{
    int i, vdim, hdim;
    int make_hscale, make_vscale, use_scales;
    int dimsizes[2];
    long time(), tloc1, tloc2;
    float *data,*hscale, *vscale, max, min;

    if (argc < 4) {
      printf("Usage:  %s outfile vdim hdim [[-h] [-v] | [-noscale]]\n",argv[0]);
      exit(1);
    }

    dimsizes[0] = vdim = atoi(argv[2]);
    dimsizes[1] = hdim = atoi(argv[3]);

    /* determine which non-uniform scales have been requested, and
       whether any scales at all are desired */
    make_hscale=make_vscale = FALSE;
    use_scales = TRUE;
    for (i=4; i<argc; i++) {
        if (strcmp(argv[i],"-h")==0) make_hscale = TRUE;
        if (strcmp(argv[i],"-v")==0) make_vscale = TRUE;
        if (strcmp(argv[i],"-noscale")==0) use_scales = FALSE;
   }

    data = (float *) malloc(vdim*hdim*sizeof(float));
    vscale = (float *) malloc(vdim*sizeof(float));
    hscale = (float *) malloc(hdim*sizeof(float));

    generate(vdim, hdim, data, vscale, hscale, &max, &min);

    i = DFSDsetdims(2,dimsizes);
    i = DFSDsetmaxmin(max, min);

    /* handle scales */
    if (use_scales) {
        if (!make_hscale)     /* if -h not chosen, generate simple h scale */
            for (i=0; i<hdim; i++)
                hscale[i] = i;
        if (!make_vscale)     /* if -v not chosen, generate simple v scale */
            for (i=0; i<vdim; i++) 
                vscale[i] = i;
    
        i = DFSDsetdimscale(1,vdim,vscale);   /* store the scales */
        i = DFSDsetdimscale(2,hdim,hscale);
    }

    DFSDadddata(argv[1], 2,dimsizes,data);

}







