/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: uiMesg.c,v 1.2 1993/05/21 16:30:44 gbourhis Exp $";
#endif


#include <string.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>

static Widget rootWidget;
static char strBuff[512];

UIErrMesg(s,okCallBack,okData,cancelCallBack,cancelData,helpCallBack,helpData)
char	*s;
void	(*okCallBack)();
caddr_t	okData;
void	(*cancelCallBack)();
caddr_t	cancelData;
void	(*helpCallBack)();
caddr_t	helpData;
{
Widget	root;
Arg     argList[10];
Cardinal i=0;
XmString mesg;
Widget	errorWidget;
int l;

        l = strlen(s);
        s = (l && l <= sizeof strBuff && s[l - 1] == '\n') ?
		(strncpy(strBuff, s, l-1)[l-1] = '\0',strBuff) : s;
        mesg = XmStringCreateLtoR(s,XmSTRING_DEFAULT_CHARSET);
        i=0;
        XtSetArg(argList[i],XtNtitle,"Error"); i++;
        XtSetArg(argList[i],XmNmessageString,mesg); i++;
        XtSetArg(argList[i],XmNmessageAlignment,XmALIGNMENT_CENTER); i++;
	errorWidget = XmCreateErrorDialog(rootWidget,"Error",argList,i);

	if (okCallBack)
		XtAddCallback(errorWidget,XmNokCallback,okCallBack,okData);
	if (cancelCallBack)
		XtAddCallback(errorWidget,XmNcancelCallback,cancelCallBack,
						cancelData);
	if (helpCallBack)
		XtAddCallback(errorWidget,XmNhelpCallback,helpCallBack,
						helpData);
	XtManageChild(errorWidget);
}	

UIWarningMesg(s,okCallBack,okData,cancelCallBack,cancelData,helpCallBack,
		helpData)
char	*s;
void	(*okCallBack)();
caddr_t	okData;
void	(*cancelCallBack)();
caddr_t	cancelData;
void	(*helpCallBack)();
caddr_t	helpData;
{
Widget	root;
Arg     argList[10];
Cardinal i=0;
XmString mesg;
Widget	warningWidget;
int l;

        l = strlen(s);
        s = (l && l <= sizeof strBuff && s[l - 1] == '\n') ?
		(strncpy(strBuff, s, l-1)[l-1] = '\0',strBuff) : s;
        mesg = XmStringCreateLtoR(s,XmSTRING_DEFAULT_CHARSET);
        i=0;
        XtSetArg(argList[i],XtNtitle,"Warning"); i++;
        XtSetArg(argList[i],XmNmessageString,mesg); i++;
        XtSetArg(argList[i],XmNmessageAlignment,XmALIGNMENT_CENTER); i++;
	warningWidget = XmCreateWarningDialog(rootWidget,"Warning",argList,i);
	if (okCallBack)
		XtAddCallback(warningWidget,XmNokCallback,okCallBack,okData);
	if (cancelCallBack)
		XtAddCallback(warningWidget,XmNcancelCallback,cancelCallBack,
						cancelData);
	if (helpCallBack)
		XtAddCallback(warningWidget,XmNhelpCallback,helpCallBack,
						helpData);
	XtManageChild(warningWidget);
}	




UIMesg(s,okCallBack,okData,cancelCallBack,cancelData,helpCallBack, helpData)
char	*s;
void	(*okCallBack)();
caddr_t	okData;
void	(*cancelCallBack)();
caddr_t	cancelData;
void	(*helpCallBack)();
caddr_t	helpData;
{
Widget	root;
Arg     argList[10];
Cardinal i=0;
XmString mesg;
Widget	mesgWidget;
int l;

        l = strlen(s);
        s = (l && l <= sizeof strBuff && s[l - 1] == '\n') ?
		(strncpy(strBuff, s, l-1)[l-1] = '\0',strBuff) : s;
        mesg = XmStringCreateLtoR(s,XmSTRING_DEFAULT_CHARSET);
        i=0;
        XtSetArg(argList[i],XtNtitle,"Information"); i++;
        XtSetArg(argList[i],XmNmessageString,mesg); i++;
        XtSetArg(argList[i],XmNmessageAlignment,XmALIGNMENT_CENTER); i++;
	mesgWidget = XmCreateInformationDialog(rootWidget,"Message",argList,i);
	if (okCallBack)
		XtAddCallback(mesgWidget,XmNokCallback,okCallBack,okData);
	if (cancelCallBack)
		XtAddCallback(mesgWidget,XmNcancelCallback,cancelCallBack,
						cancelData);
	if (helpCallBack)
		XtAddCallback(mesgWidget,XmNhelpCallback,helpCallBack,
						helpData);
	XtManageChild(mesgWidget);
}

InitUIMesg(root)
Widget root;
{
	rootWidget = root;
}

