/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: contour.c,v 1.3 1993/06/24 20:53:40 gbourhis Exp $";
#endif


#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>


#include "collageP.h"
#include "netdata.h"
#include "doodle.h"
#include "data.h"
#include "support.h"


#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif

#define CONTOUR_MODULE_NAME "Contour"
#define MAXDOODLE	((MAXDRAWDOODLE < 1000) ? MAXDRAWDOODLE : 1000)


typedef struct {
	Cdata *data;
	DColor color;
	unsigned char numLevels;
	unsigned char levels[255];
	} Contour;

static Widget	contourDialog;
static int	contourDialogShowing = FALSE;
static Widget 	helpDialog;
static char	*helpString="Contour Overlay Help:\nType in the contour levels you would like to see.  Each number should be\nseparated by a space.  The resulting contour will appear overlayed on \nthe image of the data.";

static void CBContourOverlayExecute();


static void ContourOverlayExecute(contour)
Contour *contour;
{
char *buff;
int xdim;
int ydim;
int i;
int y;
register int x;
register char *p;
char *contourData;
long numPoints;
POINT *points;
POINT *sendPoints;
long	numToSend;
long	size;

	xdim = contour->data->xdim;
	ydim = contour->data->ydim;
	size = xdim*ydim;
	contourData = contour->data->buff;

	if (!(buff = (char *)MALLOC(size))) {
		ErrMesg("Out of Memory making contour");
		return;
		}
	for(x=0,p=buff; x < size; x++) 
		*p++ = '\0';


	/* do contour */
	for (x=0; x < contour->numLevels; x++ ) {
		ContourLine(contourData,buff,contour->levels[x],1,xdim,ydim);
		}

	/* count number of points to send */
	numPoints = 0;
	for(x=0,p=buff; x < size; x++) {
		if (*p) {
			numPoints++;
			}
		p++;
		}
#ifdef DEBUG
	printf("ContourOverlayExecute(): numPoints = %d\n",numPoints);
#endif

	/* extract points */
	if (!(points = (POINT *) MALLOC(numPoints * sizeof(POINT)))) {
#ifdef DEBUG
		printf("ContourOverlayExecute(): extract points: tried to allocate %d bytes\n",numPoints * sizeof(POINT));
#endif
		ErrMesg("Out of Memory making contour (2)\n");
		FREE(buff);
		return;
		}
	i = 0;
	for(y=0; y < ydim; y++) {
		for (x = 0; x < xdim; x++) {
			if (buff[y*xdim+x]) {
				points[i].x = x;
				points[i].y = y;
				i++;
				}
			}
		}

	/*Send Points */
	sendPoints = points;
	while (numPoints > 0) {
		numToSend =(MAXDOODLE < numPoints)?MAXDOODLE:numPoints;
		NetSendDoodle(0,contour->data->name,numToSend,1,sendPoints,
				&(contour->color),TRUE,TRUE,
				TRUE,CONTOUR_MODULE_NAME);
		sendPoints += numToSend;
		numPoints -= numToSend;
#ifdef DEBUG
	printf("ContourOverlayExecute(): numToSend= %d, numPoints=%d\n",
				numToSend,numPoints);
#endif
		}

	FREE(points);
	FREE(buff);
	return;
}

/*ARGSUSED*/
static void CBContourHelpCallback(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XtManageChild(helpDialog);
}
 
/*ARGSUSED*/
static void CBContourOverlayCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Contour *contour;

	contour = (Contour *) client_data;

        XtUnmanageChild(contourDialog);
        contourDialogShowing = FALSE;

        XtRemoveCallback(contourDialog,XmNokCallback,
			CBContourOverlayExecute,(caddr_t)contour);
        XtRemoveCallback(contourDialog,XmNhelpCallback,
			CBContourHelpCallback,(caddr_t)contour);
        XtRemoveCallback(contourDialog,XmNhelpCallback,
			CBContourOverlayCancel,(caddr_t)contour);

}

static
int TranslateFtoRI(f,min,max)
float   f;
float   min,max;
/* Translate from floating point scale to int 0-255 scale */
{
        if ((max - min))
                return((int)CNV2PIX(f, min, max, BASE_PIX, NCOLORS));
        else
                return(BASE_PIX);
}


static void AdvanceToBlank(s)
char **s;
{
        /* skip over any white space (if any) */
        while( (**s) && ( (**s == ' ') || (**s == '\n') || (**s == '\t')))
                (*s)++;
        /* skip over text till next white space */
        while( (**s) && ( (**s != ' ') && (**s != '\n') && (**s != '\t')))
                (*s)++;

}


/*ARGSUSED*/
static void CBContourOverlayExecute(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Contour *contour;
Arg     argList[10];
XmString string;
char *value;
float min,max;
float floatLevel;
int intLevel;

	contour = (Contour *) client_data;

	XtUnmanageChild(contourDialog);
	contourDialogShowing = FALSE;
        XtRemoveCallback(contourDialog,XmNokCallback,
			CBContourOverlayExecute,(caddr_t)contour);
        XtRemoveCallback(contourDialog,XmNhelpCallback,
			CBContourHelpCallback,(caddr_t)contour);
        XtRemoveCallback(contourDialog,XmNhelpCallback,
			CBContourOverlayCancel,(caddr_t)contour);

        XtSetArg(argList[0],XmNtextString,&string);
        XtGetValues(contourDialog,argList,(Cardinal)1);
        XmStringGetLtoR(string,XmSTRING_DEFAULT_CHARSET,&value);

#ifdef DEBUG
	printf("contour on %s \n",value);
#endif

	if (contour->data->type == D_FLOAT) {
		contour->numLevels = 0;
		min = contour->data->min.f;
		max = contour->data->max.f;

		while(sscanf(value,"%f",&floatLevel) == 1) {
			contour->levels[contour->numLevels++] = (unsigned char)
					TranslateFtoRI(floatLevel,min,max);
			AdvanceToBlank(&value);
			}
		}
	else {
		contour->numLevels = 0;
		while(sscanf(value,"%d",&intLevel) == 1) {
			contour->levels[contour->numLevels++] = (unsigned char)
					intLevel;
			AdvanceToBlank(&value);
			}
		}

	ContourOverlayExecute(contour);
	FREE(contour);
}



static void ContourOverlayGetLevels(contour)
Contour *contour;
{
Cardinal i;
Arg argList[10];
float min,max;
static char buff[1024];
static char value[1024];
char tmp[80];
int x;
float f;
XmString label;
XmString valLabel;

	
	if (contour->data->type == D_CHAR) {
		sprintf(buff,"Contour Levels for %s\n(min = %d, max = %d)",
			contour->data->name,0,255);
		value[0]='\0';
		for (x = 0; x < 250; x += 50 ) {
			sprintf(tmp,"%d ",x);
			strcat(value,tmp);
			}
		}
	else if (contour->data->type == D_FLOAT) {
		min = contour->data->min.f;
		max = contour->data->max.f;
		sprintf(buff,"Contour Levels for %s\n (min = %f, max = %f)",
			contour->data->name,min,max);
		value[0]='\0';
		for (f = min; f < max; f += ((max - min)/5.0) ) {
			sprintf(tmp,"%f ",f);
			strcat(value,tmp);
			}
		}
	else {
		ErrMesg("Can't do a contour on this type of data\n");
		}

	i=0;
        label = XmStringCreateLtoR(buff,XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNselectionLabelString,label); i++;
        valLabel = XmStringCreateLtoR(value,XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNtextString,valLabel); i++;
	XtSetValues(contourDialog,argList,i);
	XtManageChild(contourDialog);
	contourDialogShowing = TRUE;
        XtAddCallback(contourDialog,XmNokCallback,
			CBContourOverlayExecute,(caddr_t)contour);
        XtAddCallback(contourDialog,XmNhelpCallback,
			CBContourHelpCallback,(caddr_t)contour);
        XtAddCallback(contourDialog,XmNhelpCallback,
			CBContourOverlayCancel,(caddr_t)contour);

	
}

static
ContourOverlay(d,dcolor)
Cdata *d;
DColor *dcolor;
{
Contour *contour;

	if (!(contour = (Contour *) MALLOC(sizeof(Contour)))) {
		ErrMesg("Out of Memory at Contour Overlay");
		return(0);
		}
	memcpy(&(contour->color),dcolor,sizeof(DColor));
	contour->data = d;
	ContourOverlayGetLevels(contour);
	return 1;
}

static
ContourCreateUI(topLevel)
Widget topLevel;
{
Cardinal i;
Arg argList[15];
XmString label;
XmString helpLabel;

        i= 0;
	XtSetArg(argList[i], XtNtitle, "Define Contour Levels"); i++;
        label = XmStringCreateSimple("Contour Levels:");
        XtSetArg(argList[i],XmNselectionLabelString,label); i++;
        contourDialog = XmCreatePromptDialog(topLevel,"contourDialog",
			argList,i);
	XmStringFree(label);

	contourDialogShowing = FALSE;
        i=0;
        helpLabel = XmStringCreateSimple(helpString);
        XtSetArg(argList[i],XmNmessageString,helpLabel); i++;
        helpDialog = XmCreateInformationDialog(topLevel,"helpDialog",argList,i);
	XmStringFree(helpLabel);

}

ContourInit(topWidget)
Widget topWidget;
{

	ContourCreateUI(topWidget);
}


ContourOverlayInterface(d,dcolor)
struct data_rec *d;
DColor *dcolor;
{

#ifdef DEBUG
	printf("ContourOverlayInterface(): name=%s, xdim=%d,ydim=%d\n",
				d->name,d->xdim,d->ydim);
#endif
	ContourOverlay(d,dcolor);

}
